<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-3">
            <h2 class="text-xl font-semibold leading-tight text-gray-800">Forms</h2>
            <a href="{{ route('forms.create') }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">
                New form
            </a>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="w-full px-6 space-y-4">
            @if (session('success'))
                <div class="rounded-md border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-800">
                    {{ session('success') }}
                </div>
            @endif

            <div class="overflow-hidden rounded-lg border border-slate-200 bg-white shadow-sm">
                <table class="min-w-full divide-y divide-slate-200">
                    <thead class="bg-slate-100">
                        <tr>
                            <th class="px-4 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Name</th>
                            <th class="px-4 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Public link</th>
                            <th class="px-4 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Behavior</th>
                            <th class="px-4 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Submissions</th>
                            <th class="px-4 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Status</th>
                            <th class="px-4 py-2 text-right text-xs font-semibold uppercase tracking-wide text-slate-600">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100">
                        @forelse ($forms as $form)
                            @php
                                $publicLink = route('public-forms.show', ['form' => $form->slug]);
                            @endphp
                            <tr>
                                <td class="px-4 py-3 text-sm text-slate-800">
                                    <p class="font-semibold">{{ $form->name }}</p>
                                    <p class="text-xs text-slate-500">/{{ $form->slug }}</p>
                                </td>
                                <td class="px-4 py-3 text-sm text-slate-700">
                                    <a href="{{ $publicLink }}" target="_blank" rel="noopener" class="text-indigo-600 hover:text-indigo-500 hover:underline">{{ $publicLink }}</a>
                                </td>
                                <td class="px-4 py-3 text-sm text-slate-700">{{ \Illuminate\Support\Str::headline((string) $form->behavior) }}</td>
                                <td class="px-4 py-3 text-sm text-slate-700">{{ (int) $form->submissions_count }}</td>
                                <td class="px-4 py-3 text-sm">
                                    @if ($form->is_active)
                                        <span class="inline-flex items-center rounded-full bg-emerald-100 px-2 py-1 text-xs font-semibold text-emerald-700">Active</span>
                                    @else
                                        <span class="inline-flex items-center rounded-full bg-slate-100 px-2 py-1 text-xs font-semibold text-slate-700">Disabled</span>
                                    @endif
                                </td>
                                <td class="px-4 py-3 text-right text-sm">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('forms.edit', $form) }}" class="rounded-md border border-slate-300 px-3 py-1.5 text-xs font-medium text-slate-700 hover:bg-slate-50">Edit</a>
                                        <form method="POST" action="{{ route('forms.destroy', $form) }}" onsubmit="return confirm('Delete this form?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="rounded-md border border-rose-300 px-3 py-1.5 text-xs font-medium text-rose-700 hover:bg-rose-50">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-4 py-8 text-center text-sm text-slate-500">No forms yet. Create your first form.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div>
                {{ $forms->links() }}
            </div>
        </div>
    </div>
</x-app-layout>
