@php
    $apiBaseUrl = url('/api/v1');

    $abilities = [
        ['module' => 'Tasks', 'read' => 'tasks.read', 'create' => 'tasks.create', 'update' => 'tasks.update', 'delete' => 'tasks.delete'],
        ['module' => 'Transactions', 'read' => 'deals.read', 'create' => 'deals.create', 'update' => 'deals.update', 'delete' => 'deals.delete'],
        ['module' => 'Products', 'read' => 'products.read', 'create' => 'products.create', 'update' => 'products.update', 'delete' => 'products.delete'],
        ['module' => 'Warehouses', 'read' => 'warehouses.read', 'create' => 'warehouses.create', 'update' => 'warehouses.update', 'delete' => 'warehouses.delete'],
        ['module' => 'Telephony', 'read' => 'telephony.read', 'create' => 'telephony.create', 'update' => 'telephony.update', 'delete' => 'telephony.delete'],
        ['module' => 'Messengers', 'read' => 'messengers.read', 'create' => 'messengers.create', 'update' => 'messengers.update', 'delete' => 'messengers.delete'],
        ['module' => 'Mail Service', 'read' => 'mail.read', 'create' => 'mail.create', 'update' => 'mail.update', 'delete' => 'mail.delete'],
        ['module' => 'Companies', 'read' => 'companies.read', 'create' => 'companies.create', 'update' => 'companies.update', 'delete' => 'companies.delete'],
        ['module' => 'Contacts', 'read' => 'contacts.read', 'create' => 'contacts.create', 'update' => 'contacts.update', 'delete' => 'contacts.delete'],
        ['module' => 'Projects', 'read' => 'projects.read', 'create' => 'projects.create', 'update' => 'projects.update', 'delete' => 'projects.delete'],
        ['module' => 'Disk', 'read' => 'disks.read', 'create' => 'disks.create', 'update' => 'disks.update', 'delete' => 'disks.delete'],
        ['module' => 'HR Service', 'read' => 'hr.read', 'create' => 'hr.create', 'update' => 'hr.update', 'delete' => 'hr.delete'],
        ['module' => '1C Integration', 'read' => 'onec.read', 'create' => 'onec.create', 'update' => 'onec.update', 'delete' => 'onec.delete'],
    ];

    $entities = [
        [
            'id' => 'tasks',
            'label' => 'Tasks',
            'icon' => 'fa-solid fa-list-check',
            'abilities' => ['tasks.read', 'tasks.create', 'tasks.update', 'tasks.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/tasks', 'ability' => 'tasks.read', 'description' => 'List of tasks with filters and pagination.'],
                ['method' => 'POST', 'path' => '/tasks', 'ability' => 'tasks.create', 'description' => 'Creating a task.'],
                ['method' => 'GET', 'path' => '/tasks/{id}', 'ability' => 'tasks.read', 'description' => 'Task card.'],
                ['method' => 'PATCH', 'path' => '/tasks/{id}', 'ability' => 'tasks.update', 'description' => 'Update task fields.'],
                ['method' => 'PATCH', 'path' => '/tasks/{id}/status', 'ability' => 'tasks.update', 'description' => 'Change task status.'],
                ['method' => 'PATCH', 'path' => '/tasks/{id}/complete', 'ability' => 'tasks.update', 'description' => 'Completing the task quickly.'],
                ['method' => 'DELETE', 'path' => '/tasks/{id}', 'ability' => 'tasks.delete', 'description' => 'Deleting a task.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by title/description/project/deal/parent.'],
                ['name' => 'status', 'type' => 'enum', 'description' => 'todo | in_progress | review | done'],
                ['name' => 'priority', 'type' => 'enum', 'description' => 'low | medium | high | urgent'],
                ['name' => 'assignee_id', 'type' => 'integer', 'description' => 'Filter by artist.'],
                ['name' => 'creator_id', 'type' => 'integer', 'description' => 'Filter by director.'],
                ['name' => 'project_id', 'type' => 'integer', 'description' => 'Filter by project.'],
                ['name' => 'parent_id', 'type' => 'integer', 'description' => 'Filter by parent task.'],
                ['name' => 'deadline', 'type' => 'enum', 'description' => 'overdue | today | week'],
                ['name' => 'mine', 'type' => 'boolean', 'description' => 'Only my tasks (creator/assignee = current user).'],
            ],
            'request_fields' => [
                ['name' => 'title', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:255', 'description' => 'Task name.'],
                ['name' => 'description', 'type' => 'string|null', 'required' => 'No', 'rules' => '-', 'description' => 'Detailed description.'],
                ['name' => 'deal_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:deals,id', 'description' => 'Related transaction.'],
                ['name' => 'company_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:companies,id', 'description' => 'Related company.'],
                ['name' => 'contact_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:contacts,id', 'description' => 'Related contact.'],
                ['name' => 'project_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:projects,id', 'description' => 'Project task.'],
                ['name' => 'project_stage_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:project_stages,id', 'description' => 'Project stage; requires project_id.'],
                ['name' => 'parent_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:tasks,id', 'description' => 'Parent task (subtask).'],
                ['name' => 'assignee_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'Task executor.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'todo|in_progress|review|done', 'description' => 'Current task status.'],
                ['name' => 'priority', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'low|medium|high|urgent', 'description' => 'Task priority.'],
                ['name' => 'estimated_hours', 'type' => 'number', 'required' => 'No', 'rules' => 'min:0, default 0', 'description' => 'Planned hours.'],
                ['name' => 'tracked_hours', 'type' => 'number', 'required' => 'No', 'rules' => 'min:0, default 0', 'description' => 'Actual hours.'],
                ['name' => 'sort_order', 'type' => 'integer', 'required' => 'No', 'rules' => 'min:0, default 0', 'description' => 'List/Kanban order.'],
                ['name' => 'starts_at', 'type' => 'datetime|null', 'required' => 'No', 'rules' => 'date', 'description' => 'Planned start date.'],
                ['name' => 'due_at', 'type' => 'datetime|null', 'required' => 'No', 'rules' => 'date, after_or_equal:starts_at', 'description' => 'Due date.'],
                ['name' => 'reminder_at', 'type' => 'datetime|null', 'required' => 'No', 'rules' => 'date', 'description' => 'Reminder date and time.'],
            ],
            'response_fields' => [
                ['name' => 'id', 'type' => 'integer', 'description' => 'ID tasks.'],
                ['name' => 'title, description, status, priority', 'type' => 'string', 'description' => 'Basic card data.'],
                ['name' => 'estimated_hours, tracked_hours', 'type' => 'number', 'description' => 'Plan/fact of labor costs.'],
                ['name' => 'sort_order, parent_id', 'type' => 'integer|null', 'description' => 'Position and ID of the parent.'],
                ['name' => 'starts_at, due_at, reminder_at, completed_at', 'type' => 'datetime|null', 'description' => 'Calendar dates of the task.'],
                ['name' => 'subtasks_count, done_subtasks_count', 'type' => 'integer|null', 'description' => 'Subtask counters (with whenCounted).'],
                ['name' => 'parent, deal, project, project_stage', 'type' => 'object', 'description' => 'Related entities (id + title/name).'],
                ['name' => 'company, contact, creator, assignee', 'type' => 'object|null', 'description' => 'Related resources.'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service dates.'],
            ],
            'constraints' => [
                'You cannot select a task for yourself in parent_id and you cannot specify a child task as a parent.',
                'If parent is specified_id with the project, project_id is inserted/checked automatically.',
                'project_stage_id must belong to the selected project_id.',
                'When selecting the done stage of the project, the status is forced to become done.',
            ],
        ],
        [
            'id' => 'deals',
            'label' => 'Transactions',
            'icon' => 'fa-solid fa-handshake',
            'abilities' => ['deals.read', 'deals.create', 'deals.update', 'deals.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/deals', 'ability' => 'deals.read', 'description' => 'List of deals.'],
                ['method' => 'POST', 'path' => '/deals', 'ability' => 'deals.create', 'description' => 'Creating a deal.'],
                ['method' => 'GET', 'path' => '/deals/{id}', 'ability' => 'deals.read', 'description' => 'Deal card.'],
                ['method' => 'PATCH', 'path' => '/deals/{id}', 'ability' => 'deals.update', 'description' => 'Transaction update.'],
                ['method' => 'PATCH', 'path' => '/deals/{id}/stage', 'ability' => 'deals.update', 'description' => 'Transfer through the funnel stage.'],
                ['method' => 'DELETE', 'path' => '/deals/{id}', 'ability' => 'deals.delete', 'description' => 'Deleting a deal.'],
            ],
            'filters' => [
                ['name' => 'pipeline_id', 'type' => 'integer', 'description' => 'Filter by funnel.'],
                ['name' => 'status', 'type' => 'enum', 'description' => 'open | won | lost'],
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by deal/company/contact name.'],
            ],
            'request_fields' => [
                ['name' => 'title', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:255', 'description' => 'Name of the transaction.'],
                ['name' => 'pipeline_id', 'type' => 'integer', 'required' => 'Yes', 'rules' => 'exists:pipelines,id', 'description' => 'ID sales funnels.'],
                ['name' => 'stage_id', 'type' => 'integer', 'required' => 'Yes', 'rules' => 'exists:deal_stages,id', 'description' => 'ID funnel stage.'],
                ['name' => 'company_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:companies,id', 'description' => 'Related company.'],
                ['name' => 'contact_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:contacts,id', 'description' => 'Related contact.'],
                ['name' => 'owner_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'Responsible.'],
                ['name' => 'amount', 'type' => 'number', 'required' => 'Yes', 'rules' => 'min:0', 'description' => 'Transaction amount.'],
                ['name' => 'currency', 'type' => 'string', 'required' => 'Yes', 'rules' => 'size:3', 'description' => 'Currency code, for example USD/RUB (converted to upper case).'],
                ['name' => 'priority', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'low|medium|high', 'description' => 'Priority.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'open|won|lost', 'description' => 'Transaction status.'],
                ['name' => 'expected_close_at', 'type' => 'datetime|null', 'required' => 'No', 'rules' => 'date', 'description' => 'Expected closing date.'],
                ['name' => 'source', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255', 'description' => 'Lead source.'],
                ['name' => 'lost_reason', 'type' => 'string|null', 'required' => 'No*', 'rules' => '-', 'description' => 'Reason for loss; required for status=lost.'],
                ['name' => 'description', 'type' => 'string|null', 'required' => 'No', 'rules' => '-', 'description' => 'Description and comments on the transaction.'],
            ],
            'response_fields' => [
                ['name' => 'id, title', 'type' => 'integer|string', 'description' => 'Basic fields of the transaction.'],
                ['name' => 'amount, currency', 'type' => 'number|string', 'description' => 'Amount and currency.'],
                ['name' => 'priority, status', 'type' => 'string', 'description' => 'Priority and status.'],
                ['name' => 'expected_close_at, closed_at, last_activity_at', 'type' => 'datetime|null', 'description' => 'Transaction calendar marks.'],
                ['name' => 'source, lost_reason, description', 'type' => 'string|null', 'description' => 'Additional attributes.'],
                ['name' => 'pipeline, stage', 'type' => 'object', 'description' => 'Funnel/stage (id, name, color, is_won, is_lost).'],
                ['name' => 'company, contact, owner', 'type' => 'object|null', 'description' => 'Related resources.'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service dates.'],
            ],
            'constraints' => [
                'stage_id must belong to pipeline_id.',
                'If a stage is marked as won/lost, the status can be automatically adjusted.',
                'With status=lost lost field_reason Necessarily.',
            ],
        ],
        [
            'id' => 'products',
            'label' => 'Products',
            'icon' => 'fa-solid fa-cart-shopping',
            'abilities' => ['products.read', 'products.create', 'products.update', 'products.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/products', 'ability' => 'products.read', 'description' => 'Product catalog list.'],
                ['method' => 'POST', 'path' => '/products', 'ability' => 'products.create', 'description' => 'Create a product card.'],
                ['method' => 'GET', 'path' => '/products/{id}', 'ability' => 'products.read', 'description' => 'Product card.'],
                ['method' => 'PATCH', 'path' => '/products/{id}', 'ability' => 'products.update', 'description' => 'Update product fields.'],
                ['method' => 'DELETE', 'path' => '/products/{id}', 'ability' => 'products.delete', 'description' => 'Delete product.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by name, SKU, description.'],
                ['name' => 'status', 'type' => 'enum', 'description' => 'active | archived'],
                ['name' => 'company_id', 'type' => 'integer', 'description' => 'Filter by related company.'],
                ['name' => 'owner_id', 'type' => 'integer', 'description' => 'Filter by responsible user.'],
            ],
            'request_fields' => [
                ['name' => 'name', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:255', 'description' => 'Product name.'],
                ['name' => 'sku', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:100, unique', 'description' => 'Product code/SKU.'],
                ['name' => 'price', 'type' => 'number', 'required' => 'No', 'rules' => 'min:0, default 0', 'description' => 'Product price.'],
                ['name' => 'currency', 'type' => 'string', 'required' => 'Yes', 'rules' => 'size:3', 'description' => 'Currency code in ISO format (upper-cased).'],
                ['name' => 'unit', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:32', 'description' => 'Unit of measure.'],
                ['name' => 'stock', 'type' => 'number', 'required' => 'No', 'rules' => 'min:0, default 0', 'description' => 'Current stock value.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'active|archived', 'description' => 'Product state.'],
                ['name' => 'company_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:companies,id', 'description' => 'Related company.'],
                ['name' => 'owner_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'Responsible employee.'],
                ['name' => 'description', 'type' => 'string|null', 'required' => 'No', 'rules' => '-', 'description' => 'Detailed product description.'],
            ],
            'response_fields' => [
                ['name' => 'id, name, sku, status, description', 'type' => 'mixed', 'description' => 'Basic product fields.'],
                ['name' => 'price, currency, stock, unit', 'type' => 'mixed', 'description' => 'Commercial and stock metrics.'],
                ['name' => 'company, owner', 'type' => 'object|null', 'description' => 'Related resources.'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service dates.'],
            ],
            'constraints' => [],
        ],
        [
            'id' => 'warehouses',
            'label' => 'Warehouses',
            'icon' => 'fa-solid fa-warehouse',
            'abilities' => ['warehouses.read', 'warehouses.create', 'warehouses.update', 'warehouses.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/warehouses', 'ability' => 'warehouses.read', 'description' => 'Warehouses list.'],
                ['method' => 'POST', 'path' => '/warehouses', 'ability' => 'warehouses.create', 'description' => 'Create warehouse card.'],
                ['method' => 'GET', 'path' => '/warehouses/{id}', 'ability' => 'warehouses.read', 'description' => 'Warehouse card.'],
                ['method' => 'PATCH', 'path' => '/warehouses/{id}', 'ability' => 'warehouses.update', 'description' => 'Update warehouse fields.'],
                ['method' => 'PATCH', 'path' => '/warehouses/{id}/map', 'ability' => 'warehouses.update', 'description' => 'Update warehouse map rows/columns.'],
                ['method' => 'GET', 'path' => '/warehouses/{id}/addresses', 'ability' => 'warehouses.read', 'description' => 'List of storage addresses.'],
                ['method' => 'POST', 'path' => '/warehouses/{id}/addresses', 'ability' => 'warehouses.update', 'description' => 'Create storage address.'],
                ['method' => 'PATCH', 'path' => '/warehouses/{id}/addresses/{address_id}', 'ability' => 'warehouses.update', 'description' => 'Update storage address.'],
                ['method' => 'DELETE', 'path' => '/warehouses/{id}/addresses/{address_id}', 'ability' => 'warehouses.update', 'description' => 'Delete storage address.'],
                ['method' => 'DELETE', 'path' => '/warehouses/{id}', 'ability' => 'warehouses.delete', 'description' => 'Delete warehouse.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by name, code, location, description.'],
                ['name' => 'status', 'type' => 'enum', 'description' => 'active | inactive'],
                ['name' => 'manager_id', 'type' => 'integer', 'description' => 'Filter by responsible user.'],
            ],
            'request_fields' => [
                ['name' => 'name', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:255', 'description' => 'Warehouse name.'],
                ['name' => 'code', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:100, unique', 'description' => 'Warehouse code.'],
                ['name' => 'location', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255', 'description' => 'Location.'],
                ['name' => 'capacity', 'type' => 'number', 'required' => 'No', 'rules' => 'min:0, default 0', 'description' => 'Storage capacity value.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'active|inactive', 'description' => 'Warehouse status.'],
                ['name' => 'manager_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'Responsible employee.'],
                ['name' => 'description', 'type' => 'string|null', 'required' => 'No', 'rules' => '-', 'description' => 'Warehouse description.'],
                ['name' => 'map_rows, map_columns', 'type' => 'integer', 'required' => 'No', 'rules' => 'min:1, max:200', 'description' => 'Warehouse map size.'],
                ['name' => 'address fields', 'type' => 'mixed', 'required' => 'No', 'rules' => 'code, x, y, status; optional zone/aisle/rack/shelf/cell/capacity/current_load/note/color', 'description' => 'Fields used in /addresses endpoints.'],
            ],
            'response_fields' => [
                ['name' => 'id, name, code, location, status, description', 'type' => 'mixed', 'description' => 'Main warehouse fields.'],
                ['name' => 'capacity', 'type' => 'number', 'description' => 'Capacity value.'],
                ['name' => 'manager', 'type' => 'object|null', 'description' => 'Responsible user resource.'],
                ['name' => 'map_rows, map_columns', 'type' => 'integer', 'description' => 'Configured warehouse map dimensions.'],
                ['name' => 'addresses[]', 'type' => 'array', 'description' => 'Storage addresses with coordinates and load.'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service dates.'],
            ],
            'constraints' => [],
        ],
        [
            'id' => 'companies',
            'label' => 'Companies',
            'icon' => 'fa-solid fa-building',
            'abilities' => ['companies.read', 'companies.create', 'companies.update', 'companies.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/companies', 'ability' => 'companies.read', 'description' => 'List of companies.'],
                ['method' => 'POST', 'path' => '/companies', 'ability' => 'companies.create', 'description' => 'Creation of a company.'],
                ['method' => 'GET', 'path' => '/companies/{id}', 'ability' => 'companies.read', 'description' => 'Company card.'],
                ['method' => 'PATCH', 'path' => '/companies/{id}', 'ability' => 'companies.update', 'description' => 'Company update.'],
                ['method' => 'DELETE', 'path' => '/companies/{id}', 'ability' => 'companies.delete', 'description' => 'Deleting a company.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by name/industry/email/phone.'],
            ],
            'request_fields' => [
                ['name' => 'name', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:255', 'description' => 'Company name.'],
                ['name' => 'industry', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255', 'description' => 'Industry.'],
                ['name' => 'website', 'type' => 'string|null', 'required' => 'No', 'rules' => 'url, max:255', 'description' => 'Company website.'],
                ['name' => 'phone', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:50', 'description' => 'Telephone.'],
                ['name' => 'email', 'type' => 'string|null', 'required' => 'No', 'rules' => 'email, max:255', 'description' => 'Email company.'],
                ['name' => 'address', 'type' => 'string|null', 'required' => 'No', 'rules' => '-', 'description' => 'Address.'],
                ['name' => 'owner_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'Responsible employee.'],
                ['name' => 'source', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255', 'description' => 'Lead/company source.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'lead|client|partner|inactive', 'description' => 'Current status of the company.'],
                ['name' => 'notes', 'type' => 'string|null', 'required' => 'No', 'rules' => '-', 'description' => 'Internal notes.'],
            ],
            'response_fields' => [
                ['name' => 'id, name, industry, website, phone, email, address, source, status, notes', 'type' => 'mixed', 'description' => 'Main fields of the company.'],
                ['name' => 'owner', 'type' => 'object|null', 'description' => 'Responsible user.'],
                ['name' => 'contacts_count, deals_count', 'type' => 'integer|null', 'description' => 'Connection counters (with whenCounted).'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service dates.'],
            ],
            'constraints' => [],
        ],
        [
            'id' => 'contacts',
            'label' => 'Contacts',
            'icon' => 'fa-solid fa-address-book',
            'abilities' => ['contacts.read', 'contacts.create', 'contacts.update', 'contacts.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/contacts', 'ability' => 'contacts.read', 'description' => 'Contact list.'],
                ['method' => 'POST', 'path' => '/contacts', 'ability' => 'contacts.create', 'description' => 'Creating a contact.'],
                ['method' => 'GET', 'path' => '/contacts/{id}', 'ability' => 'contacts.read', 'description' => 'Contact card.'],
                ['method' => 'PATCH', 'path' => '/contacts/{id}', 'ability' => 'contacts.update', 'description' => 'Contact update.'],
                ['method' => 'DELETE', 'path' => '/contacts/{id}', 'ability' => 'contacts.delete', 'description' => 'Deleting a contact.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by first name, last name, email, phone.'],
            ],
            'request_fields' => [
                ['name' => 'first_name', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:255', 'description' => 'Contact name.'],
                ['name' => 'last_name', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255', 'description' => 'Surname.'],
                ['name' => 'title', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255', 'description' => 'Job title.'],
                ['name' => 'email', 'type' => 'string|null', 'required' => 'No', 'rules' => 'email, max:255', 'description' => 'Email contact.'],
                ['name' => 'phone', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:50', 'description' => 'Contact phone number.'],
                ['name' => 'company_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:companies,id', 'description' => 'Related company.'],
                ['name' => 'owner_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'Responsible employee.'],
                ['name' => 'source', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255', 'description' => 'Source of contact.'],
                ['name' => 'last_contacted_at', 'type' => 'datetime|null', 'required' => 'No', 'rules' => 'date', 'description' => 'Date of last contact.'],
                ['name' => 'notes', 'type' => 'string|null', 'required' => 'No', 'rules' => '-', 'description' => 'Comment on contact.'],
            ],
            'response_fields' => [
                ['name' => 'id, first_name, last_name, full_name, title, email, phone, source, notes', 'type' => 'mixed', 'description' => 'Basic contact fields.'],
                ['name' => 'last_contacted_at', 'type' => 'datetime|null', 'description' => 'Date of last interaction.'],
                ['name' => 'company, owner', 'type' => 'object|null', 'description' => 'Related entities.'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service dates.'],
            ],
            'constraints' => [],
        ],
        [
            'id' => 'projects',
            'label' => 'Projects',
            'icon' => 'fa-solid fa-diagram-project',
            'abilities' => ['projects.read', 'projects.create', 'projects.update', 'projects.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/projects', 'ability' => 'projects.read', 'description' => 'List of projects.'],
                ['method' => 'POST', 'path' => '/projects', 'ability' => 'projects.create', 'description' => 'Creating a project.'],
                ['method' => 'GET', 'path' => '/projects/{id}', 'ability' => 'projects.read', 'description' => 'Project card.'],
                ['method' => 'PATCH', 'path' => '/projects/{id}', 'ability' => 'projects.update', 'description' => 'Project update.'],
                ['method' => 'PATCH', 'path' => '/projects/{project_id}/tasks/{task_id}/stage', 'ability' => 'projects.update', 'description' => 'Changing the stage of a task within a project.'],
                ['method' => 'DELETE', 'path' => '/projects/{id}', 'ability' => 'projects.delete', 'description' => 'Deleting a project.'],
            ],
            'filters' => [
                ['name' => 'status', 'type' => 'enum', 'description' => 'planned | active | on_hold | completed | cancelled'],
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by name/code.'],
            ],
            'request_fields' => [
                ['name' => 'name', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:255', 'description' => 'Project name.'],
                ['name' => 'code', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:40, unique', 'description' => 'Project code; if the value is empty, it is generated automatically.'],
                ['name' => 'description', 'type' => 'string|null', 'required' => 'No', 'rules' => '-', 'description' => 'Description of the project.'],
                ['name' => 'company_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:companies,id', 'description' => 'Related company.'],
                ['name' => 'deal_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:deals,id', 'description' => 'Related transaction.'],
                ['name' => 'owner_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'Project owner.'],
                ['name' => 'manager_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'Project Manager.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'planned|active|on_hold|completed|cancelled', 'description' => 'Project status.'],
                ['name' => 'priority', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'low|medium|high|critical', 'description' => 'Project priority.'],
                ['name' => 'health', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'normal|warning|risk', 'description' => 'Project status.'],
                ['name' => 'budget', 'type' => 'number', 'required' => 'No', 'rules' => 'min:0, default 0', 'description' => 'Planned budget.'],
                ['name' => 'spent', 'type' => 'number', 'required' => 'No', 'rules' => 'min:0, default 0', 'description' => 'Actual expenses.'],
                ['name' => 'starts_at', 'type' => 'datetime|null', 'required' => 'No', 'rules' => 'date', 'description' => 'Start date.'],
                ['name' => 'due_at', 'type' => 'datetime|null', 'required' => 'No', 'rules' => 'date', 'description' => 'Planned deadline.'],
                ['name' => 'visibility', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'team|private|public', 'description' => 'Project visibility level.'],
                ['name' => 'notes', 'type' => 'string|null', 'required' => 'No', 'rules' => '-', 'description' => 'Internal notes.'],
            ],
            'response_fields' => [
                ['name' => 'id, name, code, description, status, priority, health, visibility, notes', 'type' => 'mixed', 'description' => 'Main fields of the project.'],
                ['name' => 'progress', 'type' => 'integer', 'description' => 'Project progress in percentage.'],
                ['name' => 'budget, spent', 'type' => 'number', 'description' => 'Financial fields.'],
                ['name' => 'starts_at, due_at, completed_at', 'type' => 'datetime|null', 'description' => 'Calendar dates.'],
                ['name' => 'company, deal, owner, manager, members', 'type' => 'object|array|null', 'description' => 'Related entities and participants.'],
                ['name' => 'tasks_count', 'type' => 'integer|null', 'description' => 'Task counter (whenCounted).'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service dates.'],
            ],
            'constraints' => [
                'When creating, if owner_id is not specified, the current user becomes the owner.',
                'With status=completed completed field_at is set automatically.',
                'Custom endpoint /projects/{project_id}/tasks/{task_id}/stage accepts only project_stage_id.',
            ],
        ],
        [
            'id' => 'disks',
            'label' => 'Disk',
            'icon' => 'fa-solid fa-hard-drive',
            'abilities' => ['disks.read', 'disks.create', 'disks.update', 'disks.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/disks', 'ability' => 'disks.read', 'description' => 'Disk files list.'],
                ['method' => 'POST', 'path' => '/disks', 'ability' => 'disks.create', 'description' => 'Upload file to disk.'],
                ['method' => 'GET', 'path' => '/disks/{id}', 'ability' => 'disks.read', 'description' => 'Disk file card.'],
                ['method' => 'PATCH', 'path' => '/disks/{id}', 'ability' => 'disks.update', 'description' => 'Update file metadata or replace file.'],
                ['method' => 'DELETE', 'path' => '/disks/{id}', 'ability' => 'disks.delete', 'description' => 'Delete disk file.'],
                ['method' => 'GET', 'path' => '/disks/{id}/download', 'ability' => 'disks.read', 'description' => 'Download file binary.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by name/original name/folder/description.'],
                ['name' => 'folder', 'type' => 'string', 'description' => 'Filter by folder path.'],
                ['name' => 'owner_id', 'type' => 'integer', 'description' => 'Filter by owner.'],
            ],
            'request_fields' => [
                ['name' => 'file', 'type' => 'file', 'required' => 'Yes*', 'rules' => 'required on create, optional on update, max:51200 KB', 'description' => 'Uploaded file (multipart/form-data).'],
                ['name' => 'name', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255', 'description' => 'Display name of file.'],
                ['name' => 'folder', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:180, no ..', 'description' => 'Folder path in disk.'],
                ['name' => 'description', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:5000', 'description' => 'Commentary for file card.'],
                ['name' => 'is_public', 'type' => 'boolean', 'required' => 'No', 'rules' => 'boolean', 'description' => 'Visibility flag.'],
            ],
            'response_fields' => [
                ['name' => 'id, name, original_name, storage_path, folder', 'type' => 'mixed', 'description' => 'Basic file attributes.'],
                ['name' => 'mime_type, extension, size, description, is_public', 'type' => 'mixed', 'description' => 'Meta fields and file size in bytes.'],
                ['name' => 'download_url', 'type' => 'string', 'description' => 'API URL for binary file download.'],
                ['name' => 'owner', 'type' => 'object|null', 'description' => 'Owner user resource.'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service timestamps.'],
            ],
            'constraints' => [
                'Regular users without elevated role can only work with their own files unless overridden by personalized permission matrix.',
                'Folder value is sanitized and cannot contain traversal segments.',
            ],
        ],
        [
            'id' => 'telephony',
            'label' => 'Telephony',
            'icon' => 'fa-solid fa-phone',
            'abilities' => ['telephony.read', 'telephony.create', 'telephony.update', 'telephony.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/telephony/settings', 'ability' => 'telephony.read', 'description' => 'Current telephony settings.'],
                ['method' => 'PATCH', 'path' => '/telephony/settings', 'ability' => 'telephony.update', 'description' => 'Update telephony settings.'],
                ['method' => 'GET', 'path' => '/telephony/calls', 'ability' => 'telephony.read', 'description' => 'Call log list.'],
                ['method' => 'POST', 'path' => '/telephony/calls', 'ability' => 'telephony.create', 'description' => 'Create a call record.'],
                ['method' => 'GET', 'path' => '/telephony/calls/{id}', 'ability' => 'telephony.read', 'description' => 'Call details.'],
                ['method' => 'PATCH', 'path' => '/telephony/calls/{id}', 'ability' => 'telephony.update', 'description' => 'Update a call record.'],
                ['method' => 'DELETE', 'path' => '/telephony/calls/{id}', 'ability' => 'telephony.delete', 'description' => 'Delete a call record.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by from/to number or external ID.'],
                ['name' => 'direction', 'type' => 'enum', 'description' => 'inbound | outbound'],
                ['name' => 'status', 'type' => 'enum', 'description' => 'new | ringing | in_progress | completed | missed | failed'],
                ['name' => 'user_id', 'type' => 'integer', 'description' => 'Filter by responsible user.'],
                ['name' => 'date_from', 'type' => 'date', 'description' => 'Filter from start date.'],
                ['name' => 'date_to', 'type' => 'date', 'description' => 'Filter by end date.'],
            ],
            'request_fields' => [
                ['name' => 'direction', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'inbound|outbound', 'description' => 'Call direction.'],
                ['name' => 'from_number', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:60', 'description' => 'Caller number.'],
                ['name' => 'to_number', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:60', 'description' => 'Receiver number.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'new|ringing|in_progress|completed|missed|failed', 'description' => 'Call status.'],
                ['name' => 'duration_seconds', 'type' => 'integer', 'required' => 'No', 'rules' => 'min:0', 'description' => 'Call duration in seconds.'],
                ['name' => 'started_at', 'type' => 'datetime|null', 'required' => 'No', 'rules' => 'date', 'description' => 'Call start datetime.'],
                ['name' => 'ended_at', 'type' => 'datetime|null', 'required' => 'No', 'rules' => 'date', 'description' => 'Call end datetime.'],
                ['name' => 'recording_url', 'type' => 'string|null', 'required' => 'No', 'rules' => 'url, max:255', 'description' => 'Recording URL.'],
                ['name' => 'external_id', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255, unique', 'description' => 'External call ID.'],
                ['name' => 'user_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'Responsible user.'],
                ['name' => 'meta', 'type' => 'object|null', 'required' => 'No', 'rules' => '-', 'description' => 'Provider payload (optional).'],
            ],
            'response_fields' => [
                ['name' => 'id, external_id, direction, status', 'type' => 'mixed', 'description' => 'Basic call fields.'],
                ['name' => 'from_number, to_number', 'type' => 'string|null', 'description' => 'Phone numbers.'],
                ['name' => 'duration_seconds, started_at, ended_at', 'type' => 'mixed', 'description' => 'Timing and duration values.'],
                ['name' => 'recording_url', 'type' => 'string|null', 'description' => 'Recording link if available.'],
                ['name' => 'user', 'type' => 'object|null', 'description' => 'Responsible user resource.'],
                ['name' => 'meta', 'type' => 'object|null', 'description' => 'Provider payload.'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service timestamps.'],
            ],
            'constraints' => [
                'Regular users without elevated role can only access their own call log unless overridden by personalized permission matrix.',
                'Settings endpoints use fields: provider, is_active, api_base_url, api_key, api_secret, account_id, inbound_number, outbound_number, webhook_secret.',
            ],
        ],
        [
            'id' => 'messengers',
            'label' => 'Messengers',
            'icon' => 'fa-solid fa-comment-dots',
            'abilities' => ['messengers.read', 'messengers.create', 'messengers.update', 'messengers.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/messengers/settings', 'ability' => 'messengers.read', 'description' => 'Current messenger settings.'],
                ['method' => 'PATCH', 'path' => '/messengers/settings', 'ability' => 'messengers.update', 'description' => 'Update messenger settings.'],
                ['method' => 'GET', 'path' => '/messengers/channels', 'ability' => 'messengers.read', 'description' => 'Connected channels list.'],
                ['method' => 'POST', 'path' => '/messengers/channels', 'ability' => 'messengers.create', 'description' => 'Create a messenger channel.'],
                ['method' => 'GET', 'path' => '/messengers/channels/{id}', 'ability' => 'messengers.read', 'description' => 'Channel details.'],
                ['method' => 'PATCH', 'path' => '/messengers/channels/{id}', 'ability' => 'messengers.update', 'description' => 'Update channel.'],
                ['method' => 'DELETE', 'path' => '/messengers/channels/{id}', 'ability' => 'messengers.delete', 'description' => 'Delete channel.'],
                ['method' => 'GET', 'path' => '/messengers/conversations', 'ability' => 'messengers.read', 'description' => 'Conversations list.'],
                ['method' => 'POST', 'path' => '/messengers/conversations', 'ability' => 'messengers.create', 'description' => 'Create a conversation.'],
                ['method' => 'GET', 'path' => '/messengers/conversations/{id}', 'ability' => 'messengers.read', 'description' => 'Conversation details.'],
                ['method' => 'PATCH', 'path' => '/messengers/conversations/{id}', 'ability' => 'messengers.update', 'description' => 'Update a conversation.'],
                ['method' => 'DELETE', 'path' => '/messengers/conversations/{id}', 'ability' => 'messengers.delete', 'description' => 'Delete a conversation.'],
                ['method' => 'GET', 'path' => '/messengers/conversations/{id}/messages', 'ability' => 'messengers.read', 'description' => 'List messages in conversation.'],
                ['method' => 'POST', 'path' => '/messengers/conversations/{id}/messages', 'ability' => 'messengers.create', 'description' => 'Send or add a message.'],
                ['method' => 'GET', 'path' => '/messengers/messages/{id}', 'ability' => 'messengers.read', 'description' => 'Message details.'],
                ['method' => 'PATCH', 'path' => '/messengers/messages/{id}', 'ability' => 'messengers.update', 'description' => 'Update message.'],
                ['method' => 'DELETE', 'path' => '/messengers/messages/{id}', 'ability' => 'messengers.delete', 'description' => 'Delete message.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by contact name/handle/external ID.'],
                ['name' => 'status', 'type' => 'enum', 'description' => 'open | pending | closed'],
                ['name' => 'provider', 'type' => 'string', 'description' => 'Filter by provider.'],
                ['name' => 'channel_id', 'type' => 'integer', 'description' => 'Filter by channel.'],
                ['name' => 'user_id', 'type' => 'integer', 'description' => 'Filter by responsible user.'],
                ['name' => 'date_from', 'type' => 'date', 'description' => 'Filter from last message date.'],
                ['name' => 'date_to', 'type' => 'date', 'description' => 'Filter to last message date.'],
            ],
            'request_fields' => [
                ['name' => 'provider', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:60', 'description' => 'Messenger provider code.'],
                ['name' => 'name', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:255', 'description' => 'Channel display name.'],
                ['name' => 'handle', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:120', 'description' => 'Channel handle or username.'],
                ['name' => 'external_id', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255, unique per provider', 'description' => 'External channel ID.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'active|disabled', 'description' => 'Channel status.'],
                ['name' => 'is_default', 'type' => 'boolean', 'required' => 'No', 'rules' => 'boolean', 'description' => 'Default channel flag.'],
                ['name' => 'contact_name', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255', 'description' => 'Conversation contact name.'],
                ['name' => 'contact_handle', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:120', 'description' => 'Conversation handle.'],
                ['name' => 'direction', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'inbound|outbound', 'description' => 'Message direction.'],
                ['name' => 'body', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:5000', 'description' => 'Message text.'],
                ['name' => 'status (message)', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'new|sent|delivered|read|failed', 'description' => 'Message status.'],
            ],
            'response_fields' => [
                ['name' => 'id, provider, name, handle', 'type' => 'mixed', 'description' => 'Channel fields.'],
                ['name' => 'contact_name, contact_handle, status', 'type' => 'mixed', 'description' => 'Conversation fields.'],
                ['name' => 'direction, body, status, sent_at', 'type' => 'mixed', 'description' => 'Message fields.'],
                ['name' => 'channel, user, last_message', 'type' => 'object|null', 'description' => 'Related resources.'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service timestamps.'],
            ],
            'constraints' => [
                'Regular users without elevated role can only access their own conversations unless overridden by personalized permission matrix.',
                'Settings endpoints use fields: provider, is_active, api_base_url, api_key, api_secret, account_id, webhook_secret.',
            ],
        ],
        [
            'id' => 'mail',
            'label' => 'Mail Service',
            'icon' => 'fa-solid fa-envelope',
            'abilities' => ['mail.read', 'mail.create', 'mail.update', 'mail.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/mail/settings', 'ability' => 'mail.read', 'description' => 'Current mail service settings.'],
                ['method' => 'PATCH', 'path' => '/mail/settings', 'ability' => 'mail.update', 'description' => 'Update mail service settings.'],
                ['method' => 'GET', 'path' => '/mail/mailboxes', 'ability' => 'mail.read', 'description' => 'Mailboxes list.'],
                ['method' => 'POST', 'path' => '/mail/mailboxes', 'ability' => 'mail.create', 'description' => 'Issue a mailbox for a user.'],
                ['method' => 'GET', 'path' => '/mail/mailboxes/{id}', 'ability' => 'mail.read', 'description' => 'Mailbox details.'],
                ['method' => 'PATCH', 'path' => '/mail/mailboxes/{id}', 'ability' => 'mail.update', 'description' => 'Update mailbox settings.'],
                ['method' => 'DELETE', 'path' => '/mail/mailboxes/{id}', 'ability' => 'mail.delete', 'description' => 'Delete mailbox.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by address or forwarding rule.'],
                ['name' => 'status', 'type' => 'enum', 'description' => 'active | suspended | disabled'],
                ['name' => 'domain', 'type' => 'string', 'description' => 'Filter by domain.'],
                ['name' => 'user_id', 'type' => 'integer', 'description' => 'Filter by mailbox owner.'],
            ],
            'request_fields' => [
                ['name' => 'user_id', 'type' => 'integer', 'required' => 'Yes', 'rules' => 'exists:users,id', 'description' => 'Mailbox owner.'],
                ['name' => 'local_part', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:64', 'description' => 'Address local part; if empty, generated automatically.'],
                ['name' => 'domain', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:120', 'description' => 'Mailbox domain.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'active|suspended|disabled', 'description' => 'Mailbox status.'],
                ['name' => 'is_primary', 'type' => 'boolean', 'required' => 'No', 'rules' => 'boolean', 'description' => 'Primary mailbox for user.'],
                ['name' => 'quota_mb, used_mb', 'type' => 'integer', 'required' => 'No', 'rules' => 'quota min:1, used min:0', 'description' => 'Mailbox quota and current usage in MB.'],
                ['name' => 'forward_to', 'type' => 'string|null', 'required' => 'No', 'rules' => 'email|max:255', 'description' => 'Forwarding address.'],
                ['name' => 'password', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255', 'description' => 'Mailbox password/token for external provider.'],
                ['name' => 'meta', 'type' => 'object|null', 'required' => 'No', 'rules' => '-', 'description' => 'Additional provider payload.'],
            ],
            'response_fields' => [
                ['name' => 'id, address, local_part, domain, status', 'type' => 'mixed', 'description' => 'Main mailbox fields.'],
                ['name' => 'is_primary, quota_mb, used_mb, forward_to', 'type' => 'mixed', 'description' => 'Mailbox behavior and usage.'],
                ['name' => 'user', 'type' => 'object|null', 'description' => 'Owner user resource.'],
                ['name' => 'provisioned_at, created_at, updated_at', 'type' => 'datetime', 'description' => 'Provisioning and service timestamps.'],
                ['name' => 'settings fields', 'type' => 'mixed', 'description' => 'provider, is_active, domain, api_base_url, api_key, api_secret, account_id, webhook_secret, auto_provision flags, default status/quota.'],
            ],
            'constraints' => [
                'Mailbox address must be unique across the whole system.',
                'Regular users without elevated role can work only with their own mailboxes unless overridden by personalized permission matrix.',
                'When is_primary is true, other user mailboxes are demoted automatically.',
            ],
        ],
        [
            'id' => 'hr',
            'label' => 'HR Service',
            'icon' => 'fa-solid fa-user-group',
            'abilities' => ['hr.read', 'hr.create', 'hr.update', 'hr.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/hr/settings', 'ability' => 'hr.read', 'description' => 'Current HR settings.'],
                ['method' => 'PATCH', 'path' => '/hr/settings', 'ability' => 'hr.update', 'description' => 'Update HR settings.'],
                ['method' => 'GET', 'path' => '/hr/requests', 'ability' => 'hr.read', 'description' => 'HR requests list.'],
                ['method' => 'POST', 'path' => '/hr/requests', 'ability' => 'hr.create', 'description' => 'Create HR request.'],
                ['method' => 'GET', 'path' => '/hr/requests/{id}', 'ability' => 'hr.read', 'description' => 'HR request details.'],
                ['method' => 'PATCH', 'path' => '/hr/requests/{id}', 'ability' => 'hr.update', 'description' => 'Update HR request.'],
                ['method' => 'DELETE', 'path' => '/hr/requests/{id}', 'ability' => 'hr.delete', 'description' => 'Delete HR request.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by title, description, external ID.'],
                ['name' => 'type', 'type' => 'enum', 'description' => 'vacation | sick_leave | business_trip | reimbursement | onboarding | offboarding | other'],
                ['name' => 'status', 'type' => 'enum', 'description' => 'new | in_progress | waiting_approval | resolved | rejected'],
                ['name' => 'priority', 'type' => 'enum', 'description' => 'low | medium | high | urgent'],
                ['name' => 'user_id', 'type' => 'integer', 'description' => 'Filter by employee / assignee / creator user.'],
                ['name' => 'date_from, date_to', 'type' => 'date', 'description' => 'Filter by requested date.'],
            ],
            'request_fields' => [
                ['name' => 'type', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'vacation|sick_leave|business_trip|reimbursement|onboarding|offboarding|other', 'description' => 'Request type.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'new|in_progress|waiting_approval|resolved|rejected', 'description' => 'Current request status.'],
                ['name' => 'priority', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'low|medium|high|urgent', 'description' => 'Priority level.'],
                ['name' => 'title', 'type' => 'string', 'required' => 'Yes', 'rules' => 'max:255', 'description' => 'Request title.'],
                ['name' => 'description', 'type' => 'string|null', 'required' => 'No', 'rules' => '-', 'description' => 'Detailed request description.'],
                ['name' => 'requested_date, due_date, resolved_date', 'type' => 'date|null', 'required' => 'No', 'rules' => 'date', 'description' => 'Lifecycle dates.'],
                ['name' => 'employee_user_id, assignee_user_id, creator_user_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'Linked users.'],
                ['name' => 'external_id', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255, unique', 'description' => 'External request ID.'],
                ['name' => 'meta', 'type' => 'object|null', 'required' => 'No', 'rules' => 'array', 'description' => 'Additional payload.'],
                ['name' => 'settings fields', 'type' => 'mixed', 'required' => 'No', 'rules' => 'provider, is_active, api_base_url, api_key, api_secret, webhook_secret, auto_assign_user_id, default_sla_days, allow_employee_requests, require_approval', 'description' => 'Payload for /hr/settings endpoint.'],
            ],
            'response_fields' => [
                ['name' => 'id, external_id, type, status, priority, title', 'type' => 'mixed', 'description' => 'Basic request fields.'],
                ['name' => 'description, requested_date, due_date, resolved_date', 'type' => 'mixed', 'description' => 'Lifecycle and details fields.'],
                ['name' => 'employee, assignee, creator', 'type' => 'object|null', 'description' => 'Related user resources.'],
                ['name' => 'meta', 'type' => 'object|null', 'description' => 'Additional payload.'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service timestamps.'],
            ],
            'constraints' => [
                'Regular users without elevated role can access only requests where they are employee/assignee/creator unless overridden by personalized permission matrix.',
                'Webhook endpoint /api/webhooks/hr supports secret validation by X-CRM-Webhook-Secret.',
            ],
        ],
        [
            'id' => 'onec',
            'label' => '1C Integration',
            'icon' => 'fa-solid fa-database',
            'abilities' => ['onec.read', 'onec.create', 'onec.update', 'onec.delete'],
            'endpoints' => [
                ['method' => 'GET', 'path' => '/onec/settings', 'ability' => 'onec.read', 'description' => 'Current 1C settings.'],
                ['method' => 'PATCH', 'path' => '/onec/settings', 'ability' => 'onec.update', 'description' => 'Update 1C settings.'],
                ['method' => 'GET', 'path' => '/onec/exchanges', 'ability' => 'onec.read', 'description' => 'Exchange log list.'],
                ['method' => 'POST', 'path' => '/onec/exchanges', 'ability' => 'onec.create', 'description' => 'Create exchange log entry.'],
                ['method' => 'GET', 'path' => '/onec/exchanges/{id}', 'ability' => 'onec.read', 'description' => 'Exchange details.'],
                ['method' => 'PATCH', 'path' => '/onec/exchanges/{id}', 'ability' => 'onec.update', 'description' => 'Update exchange payload/status.'],
                ['method' => 'PATCH', 'path' => '/onec/exchanges/{id}/retry', 'ability' => 'onec.update', 'description' => 'Queue failed exchange for retry.'],
                ['method' => 'DELETE', 'path' => '/onec/exchanges/{id}', 'ability' => 'onec.delete', 'description' => 'Delete exchange row.'],
            ],
            'filters' => [
                ['name' => 'q', 'type' => 'string', 'description' => 'Search by external ID, error text, payload/response.'],
                ['name' => 'status', 'type' => 'enum', 'description' => 'queued | processing | completed | failed | skipped'],
                ['name' => 'direction', 'type' => 'enum', 'description' => 'inbound | outbound'],
                ['name' => 'entity', 'type' => 'enum', 'description' => 'tasks | deals | companies | contacts | products | warehouses'],
                ['name' => 'user_id', 'type' => 'integer', 'description' => 'Filter by initiator user.'],
                ['name' => 'date_from, date_to', 'type' => 'date', 'description' => 'Filter by created date.'],
            ],
            'request_fields' => [
                ['name' => 'direction', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'inbound|outbound', 'description' => 'Exchange direction.'],
                ['name' => 'entity', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'tasks|deals|companies|contacts|products|warehouses', 'description' => 'CRM entity scope.'],
                ['name' => 'action', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'upsert|create|update|delete', 'description' => 'Operation in 1C sync.'],
                ['name' => 'status', 'type' => 'enum', 'required' => 'Yes', 'rules' => 'queued|processing|completed|failed|skipped', 'description' => 'Exchange state.'],
                ['name' => 'external_id', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:255, unique per direction', 'description' => 'External exchange identifier.'],
                ['name' => 'payload, response, meta', 'type' => 'object|null', 'required' => 'No', 'rules' => 'array', 'description' => 'Structured request/response and metadata.'],
                ['name' => 'error_message', 'type' => 'string|null', 'required' => 'No', 'rules' => 'max:5000', 'description' => 'Error text for failed sync.'],
                ['name' => 'started_at, finished_at', 'type' => 'datetime|null', 'required' => 'No', 'rules' => 'date', 'description' => 'Timing fields.'],
                ['name' => 'initiated_by_user_id', 'type' => 'integer|null', 'required' => 'No', 'rules' => 'exists:users,id', 'description' => 'User who initiated sync.'],
                ['name' => 'settings fields', 'type' => 'mixed', 'required' => 'No', 'rules' => 'provider, endpoint_url, credentials, exchange_mode, sync flags, interval, webhook_secret', 'description' => 'Payload for /onec/settings endpoint.'],
            ],
            'response_fields' => [
                ['name' => 'id, external_id, direction, entity, action, status', 'type' => 'mixed', 'description' => 'Main exchange fields.'],
                ['name' => 'payload, response, meta, error_message', 'type' => 'mixed', 'description' => 'Exchange payload/result and errors.'],
                ['name' => 'initiated_by_user, started_at, finished_at', 'type' => 'object|datetime|null', 'description' => 'Initiator and timing data.'],
                ['name' => 'created_at, updated_at', 'type' => 'datetime', 'description' => 'Service timestamps.'],
            ],
            'constraints' => [
                'Regular users without elevated role can read/update only their own initiated exchanges unless overridden by personalized permission matrix.',
                'Webhook endpoint /api/webhooks/onec supports secret validation by X-CRM-Webhook-Secret.',
            ],
        ],
    ];

    $allEndpoints = [
        ['method' => 'POST', 'path' => '/auth/login', 'ability' => 'Without token'],
        ['method' => 'GET', 'path' => '/auth/me', 'ability' => 'Authorized user'],
        ['method' => 'POST', 'path' => '/auth/logout', 'ability' => 'Authorized user'],
    ];

    foreach ($entities as $entity) {
        foreach ($entity['endpoints'] as $endpoint) {
            $allEndpoints[] = [
                'method' => $endpoint['method'],
                'path' => $endpoint['path'],
                'ability' => $endpoint['ability'],
            ];
        }
    }
@endphp

<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-3">
            <h2 class="text-xl font-semibold leading-tight text-gray-800">
                API Documentation
            </h2>
            <div class="flex items-center gap-2">
                <a
                    href="{{ route('profile.edit', ['section' => 'api']) }}"
                    class="inline-flex items-center rounded-md border border-slate-300 px-3 py-1.5 text-sm font-medium text-slate-700 transition hover:border-slate-400 hover:text-slate-900"
                >
                    Return to API settings
                </a>
                <a
                    href="{{ route('docs.api') }}"
                    class="inline-flex items-center rounded-md border border-sky-200 bg-sky-50 px-3 py-1.5 text-sm font-medium text-sky-700 transition hover:border-sky-300 hover:bg-sky-100"
                    target="_blank"
                    rel="noopener"
                >
                    Open docs/api.md
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="w-full px-6">
            <div class="grid grid-cols-1 gap-6 xl:grid-cols-[18rem_minmax(0,1fr)]">
                <aside class="xl:sticky xl:top-6 xl:self-start">
                    <div class="rounded-lg border border-slate-200 bg-white p-4 shadow-sm">
                        <h3 class="text-xs font-semibold uppercase tracking-wide text-slate-500">Entity menu</h3>
                        <nav class="mt-3 space-y-1 text-sm">
                            <a href="#overview" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">Review</a>
                            <a href="#quick-start" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">Quick start</a>
                            <a href="#json-examples" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">JSON Examples</a>
                            <p class="px-2 pt-2 text-xs font-semibold uppercase tracking-wide text-slate-400">Entities</p>
                            @foreach ($entities as $entity)
                                <a href="#entity-{{ $entity['id'] }}" class="inline-flex w-full items-center gap-2 rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">
                                    <x-menu-icon :name="$entity['icon']" class="h-4 w-4 shrink-0 text-slate-500" />
                                    <span>{{ $entity['label'] }}</span>
                                </a>
                            @endforeach
                            <a href="#custom-modules" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">Custom modules</a>
                            <a href="#abilities" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">Token Rights</a>
                            <a href="#all-endpoints" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">All endpoints</a>
                        </nav>
                    </div>
                </aside>

                <div class="space-y-6">
                    <section id="overview" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">Review</h3>
                        <p class="mt-1 text-sm text-slate-600">
                            The full version is also available in the file
                            <a href="{{ route('docs.api') }}" class="font-medium text-sky-600 hover:text-sky-700 hover:underline" target="_blank" rel="noopener">
                                <code class="rounded bg-slate-100 px-1 py-0.5 text-xs">docs/api.md</code>
                            </a>.
                        </p>

                        <div class="mt-4 rounded-md border border-slate-200 bg-slate-50 p-3 text-sm text-slate-700">
                            <p><span class="font-medium text-slate-900">Base URL:</span> <code>{{ $apiBaseUrl }}</code></p>
                            <p><span class="font-medium text-slate-900">Format:</span> JSON</p>
                            <p><span class="font-medium text-slate-900">Authorization:</span> <code>Authorization: Bearer &lt;TOKEN&gt;</code></p>
                        </div>
                    </section>

                    <section id="quick-start" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">Quick start</h3>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                POST /api/v1/auth/login
                            </div>
                            <pre class="overflow-x-auto p-3 text-xs text-slate-800"><code>curl -X POST {{ $apiBaseUrl }}/auth/login \
  -H "Accept: application/json" \
  -H "Content-Type: application/json" \
  -d '{
    "email":"admin@crm.local",
    "password":"password",
    "device_name":"mobile-app"
  }'</code></pre>
                        </div>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                GET /api/v1/auth/me
                            </div>
                            <pre class="overflow-x-auto p-3 text-xs text-slate-800"><code>curl {{ $apiBaseUrl }}/auth/me \
  -H "Accept: application/json" \
  -H "Authorization: Bearer &lt;TOKEN&gt;"</code></pre>
                        </div>
                    </section>

                    <section id="json-examples" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">JSON Examples</h3>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                POST /api/v1/tasks (request)
                            </div>
                            <pre class="overflow-x-auto p-3 text-xs text-slate-800"><code>{
  "title": "Prepare a commercial proposal"
  "description": "Agree on estimates and deadlines."
  "status": "todo",
  "priority": "high",
  "assignee_id": 7,
  "project_id": 3,
  "due_at": "2026-03-05T18:00:00+03:00",
  "estimated_hours": 6
}</code></pre>
                        </div>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                POST /api/v1/tasks (response)
                            </div>
                            <pre class="overflow-x-auto p-3 text-xs text-slate-800"><code>{
  "data": {
    "id": 154,
    "title": "Prepare a commercial proposal"
    "status": "todo",
    "priority": "high",
    "estimated_hours": 6,
    "tracked_hours": 0
  }
}</code></pre>
                        </div>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                Error 422 (validation)
                            </div>
                            <pre class="overflow-x-auto p-3 text-xs text-slate-800"><code>{
  "message": "The title field is required. (and 1 more error)",
  "errors": {
    "title": [
      "The title field is required."
    ],
    "status": [
      "The selected status is invalid."
    ]
  }
}</code></pre>
                        </div>
                    </section>

                    @foreach ($entities as $entity)
                        <section id="entity-{{ $entity['id'] }}" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                            <div class="flex items-center gap-2">
                                <x-menu-icon :name="$entity['icon']" class="h-5 w-5 text-slate-500" />
                                <h3 class="text-lg font-semibold text-slate-900">{{ $entity['label'] }}</h3>
                            </div>

                            <div class="mt-4 grid grid-cols-1 gap-4 xl:grid-cols-2">
                                <div class="rounded-md border border-slate-200 bg-slate-50 p-3">
                                    <h4 class="text-xs font-semibold uppercase tracking-wide text-slate-500">Access rights</h4>
                                    <div class="mt-2 flex flex-wrap gap-1">
                                        @foreach ($entity['abilities'] as $ability)
                                            <code class="rounded bg-white px-1.5 py-0.5 text-xs text-slate-700">{{ $ability }}</code>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="rounded-md border border-slate-200 bg-slate-50 p-3">
                                    <h4 class="text-xs font-semibold uppercase tracking-wide text-slate-500">Explanation</h4>
                                    <p class="mt-2 text-sm text-slate-700">Below are all the request parameters, response fields and business constraints for the entity.</p>
                                </div>
                            </div>

                            <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                                <table class="min-w-full divide-y divide-slate-200">
                                    <thead class="bg-slate-100">
                                        <tr>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Method</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Path</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Required right</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Purpose</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-slate-100">
                                        @foreach ($entity['endpoints'] as $endpoint)
                                            <tr>
                                                <td class="px-3 py-2 text-xs font-semibold text-slate-700">{{ $endpoint['method'] }}</td>
                                                <td class="px-3 py-2 text-xs text-slate-800"><code>/api/v1{{ $endpoint['path'] }}</code></td>
                                                <td class="px-3 py-2 text-xs text-slate-700"><code>{{ $endpoint['ability'] }}</code></td>
                                                <td class="px-3 py-2 text-xs text-slate-700">{{ $endpoint['description'] }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                                <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                    List filtering options (GET /{{ $entity['id'] }})
                                </div>
                                <table class="min-w-full divide-y divide-slate-200">
                                    <thead class="bg-white">
                                        <tr>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Parameter</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Type</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Explanation</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-slate-100">
                                        @foreach ($entity['filters'] as $filter)
                                            <tr>
                                                <td class="px-3 py-2 text-xs text-slate-800"><code>{{ $filter['name'] }}</code></td>
                                                <td class="px-3 py-2 text-xs text-slate-700">{{ $filter['type'] }}</td>
                                                <td class="px-3 py-2 text-xs text-slate-700">{{ $filter['description'] }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                                <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                    Request fields (POST/PATCH)
                                </div>
                                <table class="min-w-full divide-y divide-slate-200">
                                    <thead class="bg-white">
                                        <tr>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Field</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Type</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Mandatory</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Rules</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Explanation</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-slate-100">
                                        @foreach ($entity['request_fields'] as $field)
                                            <tr>
                                                <td class="px-3 py-2 text-xs text-slate-800"><code>{{ $field['name'] }}</code></td>
                                                <td class="px-3 py-2 text-xs text-slate-700">{{ $field['type'] }}</td>
                                                <td class="px-3 py-2 text-xs text-slate-700">{{ $field['required'] }}</td>
                                                <td class="px-3 py-2 text-xs text-slate-700"><code>{{ $field['rules'] }}</code></td>
                                                <td class="px-3 py-2 text-xs text-slate-700">{{ $field['description'] }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                                <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                    Response fields
                                </div>
                                <table class="min-w-full divide-y divide-slate-200">
                                    <thead class="bg-white">
                                        <tr>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Field</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Type</th>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Explanation</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-slate-100">
                                        @foreach ($entity['response_fields'] as $field)
                                            <tr>
                                                <td class="px-3 py-2 text-xs text-slate-800"><code>{{ $field['name'] }}</code></td>
                                                <td class="px-3 py-2 text-xs text-slate-700">{{ $field['type'] }}</td>
                                                <td class="px-3 py-2 text-xs text-slate-700">{{ $field['description'] }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            @if ($entity['constraints'] !== [])
                                <div class="mt-4 rounded-lg border border-amber-200 bg-amber-50 p-3">
                                    <h4 class="text-xs font-semibold uppercase tracking-wide text-amber-700">Business restrictions</h4>
                                    <ul class="mt-2 list-disc space-y-1 pl-5 text-xs text-amber-900">
                                        @foreach ($entity['constraints'] as $constraint)
                                            <li>{{ $constraint }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                        </section>
                    @endforeach

                    <section id="custom-modules" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">Custom modules</h3>
                        <p class="mt-1 text-sm text-slate-600">
                            Upload ZIP modules with <code>module.json</code> and hook scripts to modify CRM behavior for supported entity payloads.
                        </p>

                        <div class="mt-4 rounded-md border border-slate-200 bg-slate-50 p-3 text-sm text-slate-700">
                            <p>
                                Create and manage modules in
                                <a href="{{ route('profile.edit', ['section' => 'modules']) }}" class="font-medium text-sky-600 hover:text-sky-700 hover:underline">
                                    settings window: Modules
                                </a>.
                            </p>
                            <p class="mt-2">
                                Full guide:
                                <a href="{{ route('docs.modules.page') }}" class="font-medium text-sky-600 hover:text-sky-700 hover:underline">
                                    modules documentation page
                                </a>
                                and
                                <a href="{{ route('docs.modules') }}" class="font-medium text-sky-600 hover:text-sky-700 hover:underline" target="_blank" rel="noopener">
                                    docs/modules.md
                                </a>.
                            </p>
                        </div>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                module.json example
                            </div>
                            <pre class="overflow-x-auto p-3 text-xs text-slate-800"><code>{
  "name": "Priority Automation",
  "slug": "priority-automation",
  "version": "1.0.0",
  "hooks": {
    "tasks.store": "hooks/tasks-store.php",
    "deals.store": "hooks/deals-store.php",
    "telephony.store": "hooks/telephony-store.php"
  }
}</code></pre>
                        </div>
                    </section>

                    <section id="abilities" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">Token rights (abilities)</h3>
                        <p class="mt-1 text-sm text-slate-600">If the token does not have the required ability, the API will return 403.</p>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <table class="min-w-full divide-y divide-slate-200">
                                <thead class="bg-slate-100">
                                    <tr>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Module</th>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Read</th>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Create</th>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Update</th>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Delete</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-slate-100">
                                    @foreach ($abilities as $ability)
                                        <tr>
                                            <td class="px-3 py-2 text-sm font-medium text-slate-800">{{ $ability['module'] }}</td>
                                            <td class="px-3 py-2 text-xs text-slate-700"><code>{{ $ability['read'] }}</code></td>
                                            <td class="px-3 py-2 text-xs text-slate-700"><code>{{ $ability['create'] }}</code></td>
                                            <td class="px-3 py-2 text-xs text-slate-700"><code>{{ $ability['update'] }}</code></td>
                                            <td class="px-3 py-2 text-xs text-slate-700"><code>{{ $ability['delete'] }}</code></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </section>

                    <section id="all-endpoints" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">All endpoints</h3>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <table class="min-w-full divide-y divide-slate-200">
                                <thead class="bg-slate-100">
                                    <tr>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Method</th>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Path</th>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Required right</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-slate-100">
                                    @foreach ($allEndpoints as $endpoint)
                                        <tr>
                                            <td class="px-3 py-2 text-xs font-semibold text-slate-700">{{ $endpoint['method'] }}</td>
                                            <td class="px-3 py-2 text-xs text-slate-800"><code>/api/v1{{ $endpoint['path'] }}</code></td>
                                            <td class="px-3 py-2 text-xs text-slate-700"><code>{{ $endpoint['ability'] }}</code></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
