<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('chat_messages', function (Blueprint $table): void {
            $table->foreignId('disk_id')
                ->nullable()
                ->after('body')
                ->constrained('disks')
                ->nullOnDelete();

            $table->index(['disk_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('chat_messages', function (Blueprint $table): void {
            $table->dropForeign(['disk_id']);
            $table->dropIndex(['disk_id']);
            $table->dropColumn('disk_id');
        });
    }
};

