<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('organization_settings', function (Blueprint $table): void {
            $table->id();
            $table->boolean('group_companies_enabled')->default(false);
            $table->timestamps();
        });

        Schema::create('organization_companies', function (Blueprint $table): void {
            $table->id();
            $table->string('name');
            $table->string('logo_path')->nullable();
            $table->text('requisites')->nullable();
            $table->text('address')->nullable();
            $table->json('phones')->nullable();
            $table->unsignedInteger('sort_order')->default(0);
            $table->timestamps();
        });

        Schema::table('users', function (Blueprint $table): void {
            $table->foreignId('organization_company_id')
                ->nullable()
                ->after('manager_id')
                ->constrained('organization_companies')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table): void {
            $table->dropConstrainedForeignId('organization_company_id');
        });

        Schema::dropIfExists('organization_companies');
        Schema::dropIfExists('organization_settings');
    }
};

