<?php

namespace Database\Factories;

use App\Models\Company;
use App\Models\Deal;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Project>
 */
class ProjectFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $budget = fake()->randomFloat(2, 10000, 250000);
        $status = fake()->randomElement(['planned', 'active', 'on_hold', 'completed', 'cancelled']);

        return [
            'name' => fake()->sentence(3),
            'code' => Str::upper(fake()->unique()->bothify('PRJ_##??')),
            'description' => fake()->optional()->paragraph(),
            'company_id' => fake()->boolean(60) ? Company::factory() : null,
            'deal_id' => fake()->boolean(40) ? Deal::factory() : null,
            'owner_id' => User::factory(),
            'manager_id' => User::factory(),
            'status' => $status,
            'priority' => fake()->randomElement(['low', 'medium', 'high', 'critical']),
            'health' => fake()->randomElement(['normal', 'warning', 'risk']),
            'progress' => $status === 'completed' ? 100 : fake()->numberBetween(0, 95),
            'budget' => $budget,
            'spent' => fake()->randomFloat(2, 0, $budget),
            'starts_at' => fake()->optional()->dateTimeBetween('-30 days', '+30 days'),
            'due_at' => fake()->optional()->dateTimeBetween('+15 days', '+120 days'),
            'completed_at' => $status === 'completed' ? now()->subDays(random_int(1, 30)) : null,
            'visibility' => fake()->randomElement(['team', 'private', 'public']),
            'notes' => fake()->optional()->sentence(),
        ];
    }
}
