<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class HrRequest extends Model
{
    /** @use HasFactory<\Database\Factories\HrRequestFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'external_id',
        'type',
        'status',
        'priority',
        'title',
        'description',
        'requested_date',
        'due_date',
        'resolved_date',
        'employee_user_id',
        'assignee_user_id',
        'creator_user_id',
        'meta',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'requested_date' => 'date',
            'due_date' => 'date',
            'resolved_date' => 'date',
            'employee_user_id' => 'integer',
            'assignee_user_id' => 'integer',
            'creator_user_id' => 'integer',
            'meta' => 'array',
        ];
    }

    public function employee(): BelongsTo
    {
        return $this->belongsTo(User::class, 'employee_user_id');
    }

    public function assignee(): BelongsTo
    {
        return $this->belongsTo(User::class, 'assignee_user_id');
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'creator_user_id');
    }
}

