<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\TelephonySetting */
class TelephonySettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'provider' => $this->provider,
            'is_active' => (bool) $this->is_active,
            'api_base_url' => $this->api_base_url,
            'api_key' => $this->api_key,
            'api_secret' => $this->api_secret,
            'account_id' => $this->account_id,
            'inbound_number' => $this->inbound_number,
            'outbound_number' => $this->outbound_number,
            'webhook_secret' => $this->webhook_secret,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
