<div class="space-y-4 p-5" data-sidepanel-entity="contact">
    <section class="rounded-xl border border-slate-200 bg-white p-4">
        @php
            $contactAvatarUrl = \App\Support\ProfileAvatarManager::url($contact->avatar_path);
        @endphp
        <div class="flex items-center gap-3">
            @if ($contactAvatarUrl)
                <img src="{{ $contactAvatarUrl }}" alt="{{ $contact->full_name ?: $contact->first_name }}" class="h-11 w-11 rounded-full border border-slate-200 object-cover">
            @else
                <div class="inline-flex h-11 w-11 items-center justify-center rounded-full border border-slate-200 bg-slate-100 text-sm font-semibold text-slate-600">
                    {{ strtoupper(substr((string) ($contact->full_name ?: $contact->first_name ?: 'C'), 0, 1)) }}
                </div>
            @endif
            <div>
                <h3 class="text-base font-semibold text-slate-900">{{ $contact->full_name ?: $contact->first_name }}</h3>
                <p class="text-sm text-slate-500">{{ $contact->title ?: 'Position not specified' }}</p>
            </div>
        </div>

        <dl class="mt-4 grid grid-cols-1 gap-3 text-sm sm:grid-cols-2">
            <div>
                <dt class="text-slate-500">Email</dt>
                <dd class="text-slate-900">{{ $contact->email ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Telephone</dt>
                <dd class="text-slate-900">{{ $contact->phone ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Company</dt>
                <dd class="text-slate-900">{{ $contact->company?->name ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Responsible</dt>
                <dd class="text-slate-900">{{ $contact->owner?->name ?: '—' }}</dd>
            </div>
        </dl>

        <div class="mt-4">
            <p class="text-xs font-medium uppercase tracking-wide text-slate-500">Notes</p>
            <p class="mt-1 whitespace-pre-line text-sm text-slate-900">{{ $contact->notes ?: 'No notes' }}</p>
        </div>
    </section>

    <section class="rounded-xl border border-slate-200 bg-white p-4">
        <h4 class="mb-3 text-sm font-semibold text-slate-900">Transactions ({{ $contact->deals->count() }})</h4>
        <div class="space-y-2">
            @forelse ($contact->deals->take(8) as $deal)
                <a href="{{ route('deals.show', $deal) }}" class="block rounded-lg border border-slate-200 px-3 py-2 hover:bg-slate-50">
                    <p class="text-sm font-medium text-slate-900">{{ $deal->title }}</p>
                    <p class="text-xs text-slate-500">{{ $deal->stage?->name ?? '—' }} · ${{ number_format((float) $deal->amount, 0, '.', ' ') }}</p>
                </a>
            @empty
                <p class="text-sm text-slate-500">There are no deals yet.</p>
            @endforelse
        </div>
    </section>

    <section class="rounded-xl border border-slate-200 bg-white p-4">
        <h4 class="mb-3 text-sm font-semibold text-slate-900">Tasks ({{ $contact->tasks->count() }})</h4>
        <div class="space-y-2">
            @forelse ($contact->tasks->take(8) as $task)
                <a href="{{ route('tasks.show', $task) }}" class="block rounded-lg border border-slate-200 px-3 py-2 hover:bg-slate-50">
                    <p class="text-sm font-medium text-slate-900">#{{ $task->id }} · {{ $task->title }}</p>
                    <p class="text-xs text-slate-500">{{ strtoupper($task->status) }} · {{ $task->due_at?->format('d.m H:i') ?: 'No deadline' }}</p>
                </a>
            @empty
                <p class="text-sm text-slate-500">There are no tasks yet.</p>
            @endforelse
        </div>
    </section>

    <div class="flex items-center gap-2">
        <a href="{{ route('contacts.show', $contact) }}" data-sidepanel="off" class="inline-flex items-center rounded-md border border-slate-300 px-3 py-2 text-sm font-medium text-slate-700 hover:bg-slate-50">
            Open card
        </a>
        <a href="{{ route('contacts.edit', $contact) }}" data-sidepanel="off" class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-medium text-white hover:bg-indigo-500">
            Edit
        </a>
    </div>
</div>
