<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">{{ $activity->subject }}</h2>
                <p class="text-sm text-gray-500">{{ strtoupper($activity->type) }} · {{ strtoupper($activity->direction) }}</p>
            </div>
            <a href="{{ route('activities.edit', $activity) }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">Edit</a>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6">
            <div class="bg-white border border-gray-200 rounded-xl p-6">
                <dl class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                    <div>
                        <dt class="text-gray-500">Date</dt>
                        <dd class="text-gray-900">{{ $activity->occurred_at?->format('d.m.Y H:i') }}</dd>
                    </div>
                    <div>
                        <dt class="text-gray-500">User</dt>
                        <dd class="text-gray-900">{{ $activity->user?->name ?? 'System' }}</dd>
                    </div>
                    <div>
                        <dt class="text-gray-500">Deal</dt>
                        <dd class="text-gray-900">{{ $activity->deal?->title ?? '—' }}</dd>
                    </div>
                    <div>
                        <dt class="text-gray-500">Company</dt>
                        <dd class="text-gray-900">{{ $activity->company?->name ?? '—' }}</dd>
                    </div>
                    <div>
                        <dt class="text-gray-500">Contact</dt>
                        <dd class="text-gray-900">{{ $activity->contact?->full_name ?? '—' }}</dd>
                    </div>
                    <div>
                        <dt class="text-gray-500">Result</dt>
                        <dd class="text-gray-900">{{ $activity->outcome ?: '—' }}</dd>
                    </div>
                </dl>

                <div class="mt-4 text-sm">
                    <p class="text-gray-500">Details</p>
                    <p class="mt-1 whitespace-pre-line text-gray-900">{{ $activity->details ?: 'No details' }}</p>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
