<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('users') || Schema::hasColumn('users', 'preferred_project_view')) {
            return;
        }

        Schema::table('users', function (Blueprint $table): void {
            $table->string('preferred_project_view', 20)
                ->default('list')
                ->after('preferred_deal_view');
        });
    }

    public function down(): void
    {
        if (! Schema::hasTable('users') || ! Schema::hasColumn('users', 'preferred_project_view')) {
            return;
        }

        Schema::table('users', function (Blueprint $table): void {
            $table->dropColumn('preferred_project_view');
        });
    }
};
