<?php

namespace Database\Factories;

use App\Models\Project;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ProjectStage>
 */
class ProjectStageFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = fake()->randomElement(['Backlog', 'In Progress', 'Review', 'QA', 'Done']);

        return [
            'project_id' => Project::factory(),
            'name' => $name,
            'code' => Str::slug($name, '_').'_'.fake()->unique()->numberBetween(1, 999),
            'sort_order' => fake()->numberBetween(0, 10),
            'wip_limit' => fake()->optional()->numberBetween(2, 12),
            'is_done' => Str::lower($name) === 'done',
        ];
    }
}
