<?php

namespace App\Support;

class ProfileAvatarManager
{
    public const DEFAULT_FOCUS_X = 50;

    public const DEFAULT_FOCUS_Y = 50;

    public const DEFAULT_ZOOM = 1.0;

    public static function normalizeFocusX(mixed $value): int
    {
        return self::normalizeFocus($value);
    }

    public static function normalizeFocusY(mixed $value): int
    {
        return self::normalizeFocus($value);
    }

    public static function normalizeZoom(mixed $value): float
    {
        if (! is_numeric($value)) {
            return self::DEFAULT_ZOOM;
        }

        $zoom = (float) $value;
        $zoom = max(1.0, min(3.0, $zoom));

        return round($zoom, 2);
    }

    public static function url(?string $path): ?string
    {
        if (! is_string($path) || trim($path) === '') {
            return null;
        }

        return asset('storage/'.ltrim($path, '/'));
    }

    public static function style(mixed $focusX, mixed $focusY, mixed $zoom): string
    {
        $z = self::normalizeZoom($zoom);

        return sprintf(
            'object-position: center center; transform: scale(%s); transform-origin: center center;',
            rtrim(rtrim(number_format($z, 2, '.', ''), '0'), '.')
        );
    }

    private static function normalizeFocus(mixed $value): int
    {
        if (! is_numeric($value)) {
            return self::DEFAULT_FOCUS_X;
        }

        $focus = (int) round((float) $value);

        return max(0, min(100, $focus));
    }
}
