<?php

namespace App\Policies;

use App\Models\Disk;
use App\Models\User;
use App\Support\AccessControl;

class DiskPolicy
{
    public function viewAny(User $user): bool
    {
        return AccessControl::allows($user, 'disks', 'read');
    }

    public function view(User $user, Disk $disk): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'disks', 'read');
        if ($decision !== null) {
            return $decision;
        }

        if (! AccessControl::roleAllows($user, 'disks', 'read')) {
            return false;
        }

        return AccessControl::isElevated($user) || $disk->owner_id === $user->id;
    }

    public function create(User $user): bool
    {
        return AccessControl::allows($user, 'disks', 'create');
    }

    public function update(User $user, Disk $disk): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'disks', 'update');
        if ($decision !== null) {
            return $decision;
        }

        if (! AccessControl::roleAllows($user, 'disks', 'update')) {
            return false;
        }

        return AccessControl::isElevated($user) || $disk->owner_id === $user->id;
    }

    public function delete(User $user, Disk $disk): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'disks', 'delete');
        if ($decision !== null) {
            return $decision;
        }

        if (! AccessControl::roleAllows($user, 'disks', 'delete')) {
            return false;
        }

        return AccessControl::isElevated($user) || $disk->owner_id === $user->id;
    }
}
