<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class WebForm extends Model
{
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'owner_id',
        'name',
        'slug',
        'description',
        'submit_label',
        'show_reset_button',
        'reset_label',
        'success_message',
        'is_active',
        'behavior',
        'behavior_settings',
        'fields',
        'style_settings',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'show_reset_button' => 'boolean',
            'is_active' => 'boolean',
            'behavior_settings' => 'array',
            'fields' => 'array',
            'style_settings' => 'array',
        ];
    }

    public function owner(): BelongsTo
    {
        return $this->belongsTo(User::class, 'owner_id');
    }

    public function submissions(): HasMany
    {
        return $this->hasMany(WebFormSubmission::class)->orderByDesc('submitted_at');
    }
}
