<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OneCSetting extends Model
{
    /** @use HasFactory<\Database\Factories\OneCSettingFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'provider',
        'is_active',
        'endpoint_url',
        'username',
        'password',
        'api_key',
        'api_secret',
        'webhook_secret',
        'exchange_mode',
        'auto_sync',
        'sync_tasks',
        'sync_deals',
        'sync_companies',
        'sync_contacts',
        'sync_products',
        'sync_warehouses',
        'sync_interval_minutes',
        'last_sync_at',
        'meta',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
            'auto_sync' => 'boolean',
            'sync_tasks' => 'boolean',
            'sync_deals' => 'boolean',
            'sync_companies' => 'boolean',
            'sync_contacts' => 'boolean',
            'sync_products' => 'boolean',
            'sync_warehouses' => 'boolean',
            'sync_interval_minutes' => 'integer',
            'last_sync_at' => 'datetime',
            'meta' => 'array',
        ];
    }
}

