<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MessengerSetting extends Model
{
    /** @use HasFactory<\Database\Factories\MessengerSettingFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'provider',
        'is_active',
        'api_base_url',
        'api_key',
        'api_secret',
        'account_id',
        'allowed_operator_ids',
        'auto_create_contact',
        'new_contact_action',
        'new_contact_action_user_id',
        'webhook_secret',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
            'allowed_operator_ids' => 'array',
            'auto_create_contact' => 'boolean',
            'new_contact_action_user_id' => 'integer',
        ];
    }
}
