<?php

namespace App\Http\Resources;

use App\Support\DiskFileIconResolver;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\Disk */
class DiskResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $iconMeta = DiskFileIconResolver::resolve((string) ($this->extension ?? ''), (string) ($this->mime_type ?? ''));

        return [
            'id' => $this->id,
            'name' => $this->name,
            'original_name' => $this->original_name,
            'storage_path' => $this->storage_path,
            'folder' => $this->folder,
            'mime_type' => $this->mime_type,
            'extension' => $this->extension,
            'file_icon' => $iconMeta['icon'],
            'file_type_label' => $iconMeta['label'],
            'size' => (int) $this->size,
            'description' => $this->description,
            'is_public' => (bool) $this->is_public,
            'download_url' => url('/api/v1/disks/'.$this->id.'/download'),
            'owner' => UserResource::make($this->whenLoaded('owner')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
