@php
    $warehouse = $warehouse ?? null;
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label for="name" class="block text-sm font-medium text-gray-700">{{ __('Name') }}</label>
        <input id="name" name="name" type="text" required value="{{ old('name', $warehouse?->name) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="code" class="block text-sm font-medium text-gray-700">{{ __('Code') }}</label>
        <input id="code" name="code" type="text" value="{{ old('code', $warehouse?->code) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="location" class="block text-sm font-medium text-gray-700">{{ __('Location') }}</label>
        <input id="location" name="location" type="text" value="{{ old('location', $warehouse?->location) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="capacity" class="block text-sm font-medium text-gray-700">{{ __('Capacity') }}</label>
        <input id="capacity" name="capacity" type="number" min="0" step="0.01" value="{{ old('capacity', $warehouse?->capacity ?? 0) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="map_rows" class="block text-sm font-medium text-gray-700">{{ __('Map rows') }}</label>
        <input id="map_rows" name="map_rows" type="number" min="1" max="200" value="{{ old('map_rows', $warehouse?->map_rows ?? 8) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="map_columns" class="block text-sm font-medium text-gray-700">{{ __('Map columns') }}</label>
        <input id="map_columns" name="map_columns" type="number" min="1" max="200" value="{{ old('map_columns', $warehouse?->map_columns ?? 12) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="status" class="block text-sm font-medium text-gray-700">{{ __('Status') }}</label>
        <select id="status" name="status" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach ($statusOptions as $value => $label)
                <option value="{{ $value }}" @selected(old('status', $warehouse?->status ?? 'active') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="manager_id" class="block text-sm font-medium text-gray-700">{{ __('Responsible') }}</label>
        <x-user-search-select
            id="manager_id"
            name="manager_id"
            :users="$managers"
            :selected="old('manager_id', $warehouse?->manager_id)"
            :placeholder="__('Finding the person responsible')"
            :empty-label="__('Not assigned')"
        />
    </div>
</div>

<div class="mt-4">
    <label for="description" class="block text-sm font-medium text-gray-700">{{ __('Description') }}</label>
    <textarea id="description" name="description" rows="4" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('description', $warehouse?->description) }}</textarea>
</div>
