@php
    $priorityOptions = [
        'low' => 'Short',
        'medium' => 'Average',
        'high' => 'High',
        'urgent' => 'Urgent',
    ];
    $liveContext = $liveContext ?? 'page';
    $fieldPrefix = "task-live-{$liveContext}-{$task->id}";
    $selectedProjectId = (int) ($task->project_id ?? 0);
    $selectedProjectStageId = (int) ($task->project_stage_id ?? 0);
    $projectStageMap = $projects
        ->mapWithKeys(fn ($project) => [
            $project->id => $project->stages
                ->map(fn ($stage) => ['id' => $stage->id, 'name' => $stage->name])
                ->values(),
        ])
        ->all();
@endphp

<form
    class="space-y-4"
    data-task-live-form
    data-update-url="{{ route('tasks.update', $task) }}"
    data-project-stage-map='@json($projectStageMap)'
    data-task-id="{{ $task->id }}"
>
    <div class="flex items-center justify-between gap-3 rounded-lg border border-slate-200 bg-slate-50 px-3 py-2">
        <p class="text-xs text-slate-600">Changes are saved automatically</p>
        <span class="text-xs font-medium text-slate-600" data-task-live-status>Ready</span>
    </div>

    <div class="hidden rounded-lg border border-red-200 bg-red-50 px-3 py-2 text-xs text-red-700" data-task-live-error></div>

    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
        <div class="md:col-span-2">
            <label for="{{ $fieldPrefix }}-title" class="block text-sm font-medium text-slate-700">Task name</label>
            <input
                id="{{ $fieldPrefix }}-title"
                name="title"
                type="text"
                required
                value="{{ $task->title }}"
                class="mt-1 w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
            >
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-status" class="block text-sm font-medium text-slate-700">Status</label>
            <select id="{{ $fieldPrefix }}-status" name="status" required class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                @foreach ($taskStatusOptions as $value => $label)
                    <option value="{{ $value }}" @selected($task->status === $value)>{{ $label }}</option>
                @endforeach
            </select>
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-priority" class="block text-sm font-medium text-slate-700">Priority</label>
            <select id="{{ $fieldPrefix }}-priority" name="priority" required class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                @foreach ($priorityOptions as $value => $label)
                    <option value="{{ $value }}" @selected($task->priority === $value)>{{ $label }}</option>
                @endforeach
            </select>
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-assignee" class="block text-sm font-medium text-slate-700">Executor</label>
            <x-user-search-select
                :id="$fieldPrefix.'-assignee'"
                name="assignee_id"
                :users="$users"
                :selected="$task->assignee_id"
                placeholder="Search for an artist"
                empty-label="Not assigned"
                input-class="border-slate-300 text-sm"
            />
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-parent" class="block text-sm font-medium text-slate-700">Parent task</label>
            <select id="{{ $fieldPrefix }}-parent" name="parent_id" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">Without parent</option>
                @foreach ($parentTasks as $parentTask)
                    @continue($parentTask->id === $task->id)
                    <option value="{{ $parentTask->id }}" @selected((int) $task->parent_id === $parentTask->id)>#{{ $parentTask->id }} · {{ $parentTask->title }}</option>
                @endforeach
            </select>
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-starts" class="block text-sm font-medium text-slate-700">Start</label>
            <input id="{{ $fieldPrefix }}-starts" name="starts_at" type="datetime-local" value="{{ $task->starts_at?->format('Y-m-d\TH:i') }}" class="mt-1 w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-due" class="block text-sm font-medium text-slate-700">Term</label>
            <input id="{{ $fieldPrefix }}-due" name="due_at" type="datetime-local" value="{{ $task->due_at?->format('Y-m-d\TH:i') }}" class="mt-1 w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-reminder" class="block text-sm font-medium text-slate-700">Reminder</label>
            <input id="{{ $fieldPrefix }}-reminder" name="reminder_at" type="datetime-local" value="{{ $task->reminder_at?->format('Y-m-d\TH:i') }}" class="mt-1 w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-project" class="block text-sm font-medium text-slate-700">Project</label>
            <select id="{{ $fieldPrefix }}-project" name="project_id" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">Without a project</option>
                @foreach ($projects as $project)
                    <option value="{{ $project->id }}" @selected($selectedProjectId === $project->id)>{{ $project->name }}</option>
                @endforeach
            </select>
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-project-stage" class="block text-sm font-medium text-slate-700">Project stage</label>
            <select id="{{ $fieldPrefix }}-project-stage" name="project_stage_id" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">No stage</option>
                @foreach (($projects->firstWhere('id', $selectedProjectId)?->stages ?? collect()) as $stage)
                    <option value="{{ $stage->id }}" @selected($selectedProjectStageId === $stage->id)>{{ $stage->name }}</option>
                @endforeach
            </select>
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-deal" class="block text-sm font-medium text-slate-700">Deal</label>
            <select id="{{ $fieldPrefix }}-deal" name="deal_id" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">No binding</option>
                @foreach ($deals as $deal)
                    <option value="{{ $deal->id }}" @selected((int) $task->deal_id === $deal->id)>{{ $deal->title }}</option>
                @endforeach
            </select>
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-company" class="block text-sm font-medium text-slate-700">Company</label>
            <select id="{{ $fieldPrefix }}-company" name="company_id" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">No binding</option>
                @foreach ($companies as $company)
                    <option value="{{ $company->id }}" @selected((int) $task->company_id === $company->id)>{{ $company->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="md:col-span-2">
            <label for="{{ $fieldPrefix }}-contact" class="block text-sm font-medium text-slate-700">Contact</label>
            <select id="{{ $fieldPrefix }}-contact" name="contact_id" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">No binding</option>
                @foreach ($contacts as $contact)
                    <option value="{{ $contact->id }}" @selected((int) $task->contact_id === $contact->id)>{{ $contact->full_name ?: $contact->first_name }}</option>
                @endforeach
            </select>
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-estimated" class="block text-sm font-medium text-slate-700">Hours plan</label>
            <input id="{{ $fieldPrefix }}-estimated" name="estimated_hours" type="number" min="0" step="0.1" value="{{ $task->estimated_hours }}" class="mt-1 w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-tracked" class="block text-sm font-medium text-slate-700">Clock fact</label>
            <input id="{{ $fieldPrefix }}-tracked" name="tracked_hours" type="number" min="0" step="0.1" value="{{ $task->tracked_hours }}" class="mt-1 w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
        </div>

        <div>
            <label for="{{ $fieldPrefix }}-sort" class="block text-sm font-medium text-slate-700">Sorting</label>
            <input id="{{ $fieldPrefix }}-sort" name="sort_order" type="number" min="0" step="1" value="{{ $task->sort_order }}" class="mt-1 w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
        </div>
    </div>

    <div>
        <label for="{{ $fieldPrefix }}-description" class="block text-sm font-medium text-slate-700">Description</label>
        <textarea id="{{ $fieldPrefix }}-description" name="description" rows="4" class="mt-1 w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ $task->description }}</textarea>
    </div>
</form>
