<section id="menu-settings" class="space-y-6">
    <header>
        <h2 class="text-lg font-medium text-gray-900">Menu setup</h2>
        <p class="mt-1 text-sm text-gray-600">
            Hide items, change the order and add your own links with an icon.
        </p>
    </header>

    <form method="POST" action="{{ route('profile.menu.update') }}" class="space-y-4" id="menu-settings-form">
        @csrf
        @method('PATCH')

        <div class="overflow-hidden rounded-lg border border-gray-200">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Order</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Icon</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Menu item</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Link</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">New tab</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Visibility</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Delete</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100 bg-white" data-menu-rows>
                    @foreach ($menuItems as $item)
                        <tr data-item-id="{{ $item['id'] }}">
                            <td class="px-4 py-3 align-top">
                                <div class="inline-flex gap-1">
                                    <button
                                        type="button"
                                        data-move="up"
                                        class="inline-flex h-8 w-8 items-center justify-center rounded-md border border-gray-300 text-sm text-gray-700 hover:bg-gray-50"
                                        title="Higher"
                                    >↑</button>
                                    <button
                                        type="button"
                                        data-move="down"
                                        class="inline-flex h-8 w-8 items-center justify-center rounded-md border border-gray-300 text-sm text-gray-700 hover:bg-gray-50"
                                        title="Below"
                                    >↓</button>
                                </div>
                            </td>
                            <td class="px-4 py-3 align-top">
                                <div class="flex h-10 w-10 items-center justify-center rounded-lg bg-slate-100 text-slate-700">
                                    <x-menu-icon :name="$item['icon']" class="h-5 w-5" />
                                </div>
                                @if ($item['is_custom'])
                                    <div class="mt-2">
                                        <select name="custom[{{ $item['id'] }}][icon]" class="w-full rounded-md border-gray-300 text-xs shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                            @foreach ($menuIcons as $iconName => $iconMeta)
                                                <option value="{{ $iconName }}" @selected($item['icon'] === $iconName)>{{ $iconMeta['label'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                @endif
                            </td>
                            <td class="px-4 py-3 align-top">
                                @if ($item['is_custom'])
                                    <input
                                        type="text"
                                        name="custom[{{ $item['id'] }}][label]"
                                        value="{{ $item['label'] }}"
                                        class="w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                        placeholder="Name"
                                    >
                                @else
                                    <div class="text-sm font-medium text-gray-900">{{ $item['label'] }}</div>
                                    <p class="text-xs text-gray-500">System point</p>
                                @endif
                            </td>
                            <td class="px-4 py-3 align-top">
                                @if ($item['is_custom'])
                                    <input
                                        type="url"
                                        name="custom[{{ $item['id'] }}][url]"
                                        value="{{ $item['url'] }}"
                                        class="w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                        placeholder="https://example.com"
                                    >
                                @else
                                    <span class="text-sm text-gray-500">Built-in section</span>
                                @endif
                            </td>
                            <td class="px-4 py-3 align-top">
                                @if ($item['is_custom'])
                                    <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                        <input
                                            type="checkbox"
                                            name="custom[{{ $item['id'] }}][open_in_new_tab]"
                                            value="1"
                                            @checked($item['open_in_new_tab'] ?? false)
                                            class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                                        >
                                        Open
                                    </label>
                                @else
                                    <span class="text-xs text-gray-400">—</span>
                                @endif
                            </td>
                            <td class="px-4 py-3 align-top">
                                <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                    <input
                                        type="checkbox"
                                        name="visible[{{ $item['id'] }}]"
                                        value="1"
                                        @checked($item['is_visible'])
                                        class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                                    >
                                    Show
                                </label>
                            </td>
                            <td class="px-4 py-3 align-top">
                                @if ($item['is_custom'])
                                    <label class="inline-flex items-center gap-2 text-sm text-red-600">
                                        <input
                                            type="checkbox"
                                            name="custom[{{ $item['id'] }}][delete]"
                                            value="1"
                                            class="rounded border-gray-300 text-red-600 shadow-sm focus:ring-red-500"
                                        >
                                        Delete
                                    </label>
                                @else
                                    <span class="text-xs text-gray-400">—</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div id="menu-order-inputs"></div>

        <div class="flex items-center gap-3">
            <x-primary-button>Save menu</x-primary-button>
            @if (session('status') === 'menu-updated')
                <span class="text-sm text-gray-600">Saved.</span>
            @endif
        </div>
    </form>

    <form method="POST" action="{{ route('profile.menu.custom.store') }}" class="rounded-lg border border-gray-200 p-4">
        @csrf
        <h3 class="text-sm font-semibold text-gray-900">Add your menu item</h3>

        <div class="mt-3 grid grid-cols-1 lg:grid-cols-4 gap-3">
            <div class="lg:col-span-1">
                <label for="custom-label" class="block text-xs font-medium uppercase text-gray-500">Name</label>
                <input
                    id="custom-label"
                    type="text"
                    name="label"
                    required
                    class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                    placeholder="Knowledge Base"
                >
            </div>

            <div class="lg:col-span-2">
                <label for="custom-url" class="block text-xs font-medium uppercase text-gray-500">Link</label>
                <input
                    id="custom-url"
                    type="url"
                    name="url"
                    required
                    class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                    placeholder="https://..."
                >
            </div>

            <div class="lg:col-span-1">
                <label for="custom-icon" class="block text-xs font-medium uppercase text-gray-500">Icon</label>
                <select id="custom-icon" name="icon" required class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    @foreach ($menuIcons as $iconName => $iconMeta)
                        <option value="{{ $iconName }}">{{ $iconMeta['label'] }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <label class="mt-3 inline-flex items-center gap-2 text-sm text-gray-700">
            <input
                type="checkbox"
                name="open_in_new_tab"
                value="1"
                class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
            >
            Open link in new tab
        </label>

        <div class="mt-4">
            <x-primary-button>Add link</x-primary-button>
        </div>
    </form>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const tableBody = document.querySelector('[data-menu-rows]');
            const orderContainer = document.getElementById('menu-order-inputs');

            if (!tableBody || !orderContainer) {
                return;
            }

            const rebuildOrderInputs = () => {
                orderContainer.innerHTML = '';

                Array.from(tableBody.querySelectorAll('tr[data-item-id]')).forEach((row) => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'order[]';
                    input.value = row.dataset.itemId;
                    orderContainer.appendChild(input);
                });
            };

            tableBody.querySelectorAll('button[data-move]').forEach((button) => {
                button.addEventListener('click', () => {
                    const row = button.closest('tr[data-item-id]');
                    if (!row) {
                        return;
                    }

                    if (button.dataset.move === 'up' && row.previousElementSibling) {
                        tableBody.insertBefore(row, row.previousElementSibling);
                    }

                    if (button.dataset.move === 'down' && row.nextElementSibling) {
                        tableBody.insertBefore(row.nextElementSibling, row);
                    }

                    rebuildOrderInputs();
                });
            });

            rebuildOrderInputs();
        });
    </script>
</section>
