<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">{{ __('Products') }}</h2>
            <a href="{{ route('products.create') }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">{{ __('New product') }}</a>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-4">
            <div class="bg-white border border-gray-200 rounded-xl p-4">
                <form method="GET" action="{{ route('products.index') }}" class="grid grid-cols-1 gap-3 md:grid-cols-[minmax(0,1fr)_220px_auto]">
                    <input type="text" name="q" value="{{ $search }}" placeholder="{{ __('Search by name, SKU, description') }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <select name="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <option value="">{{ __('All statuses') }}</option>
                        @foreach ($statusOptions as $value => $label)
                            <option value="{{ $value }}" @selected($status === $value)>{{ $label }}</option>
                        @endforeach
                    </select>
                    <button type="submit" class="inline-flex items-center justify-center rounded-md bg-gray-800 px-4 py-2 text-sm font-medium text-white hover:bg-gray-700">{{ __('Find') }}</button>
                </form>
            </div>

            <div class="bg-white border border-gray-200 rounded-xl overflow-hidden">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Product') }}</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Price') }}</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('In stock') }}</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Company') }}</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Responsible') }}</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Status') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 bg-white">
                        @forelse ($products as $product)
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3">
                                    <a href="{{ route('products.show', $product) }}" class="font-medium text-gray-900 hover:text-indigo-600">{{ $product->name }}</a>
                                    <div class="text-xs text-gray-500">{{ $product->sku ?: '—' }}</div>
                                </td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ number_format((float) $product->price, 2, '.', ' ') }} {{ strtoupper((string) $product->currency) }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ number_format((float) $product->stock, 3, '.', ' ') }} {{ $product->unit }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $product->company?->name ?: '—' }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $product->owner?->name ?: '—' }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $statusOptions[$product->status] ?? ucfirst((string) $product->status) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-4 py-8 text-center text-sm text-gray-500">{{ __('No products found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div>
                {{ $products->links() }}
            </div>
        </div>
    </div>
</x-app-layout>
