@php
    $stageColorValues = old(
        'stage_colors',
        $pipeline->stages
            ->mapWithKeys(fn ($stage) => [$stage->id => preg_match('/^#[0-9A-Fa-f]{6}$/', (string) $stage->color) ? strtoupper((string) $stage->color) : '#94A3B8'])
            ->all()
    );
@endphp

<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Editing a funnel</h2>
            <a href="{{ route('deals.index', ['pipeline_id' => $pipeline->id]) }}" class="text-sm text-indigo-600 hover:text-indigo-500">Open trades</a>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-4">
            <form method="POST" action="{{ route('pipelines.update', $pipeline) }}" class="bg-white border border-gray-200 rounded-xl p-6 space-y-4">
                @csrf
                @method('PUT')

                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
                    <input id="name" name="name" type="text" required value="{{ old('name', $pipeline->name) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                    <textarea id="description" name="description" rows="3" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('description', $pipeline->description) }}</textarea>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="sort_order" class="block text-sm font-medium text-gray-700">Order</label>
                        <input id="sort_order" name="sort_order" type="number" min="0" value="{{ old('sort_order', $pipeline->sort_order) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>

                    <div class="flex items-center gap-6 pt-6">
                        <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                            <input type="checkbox" name="is_active" value="1" @checked(old('is_active', $pipeline->is_active)) class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                            Active
                        </label>
                        <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                            <input type="checkbox" name="is_default" value="1" @checked(old('is_default', $pipeline->is_default)) class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                            Default
                        </label>
                    </div>
                </div>

                <div>
                    <label for="stages" class="block text-sm font-medium text-gray-700">Stages (each on a new line)</label>
                    <textarea id="stages" name="stages" rows="8" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('stages', $stages) }}</textarea>
                </div>

                <div class="rounded-lg border border-gray-200 p-4">
                    <h3 class="text-sm font-semibold text-gray-900">Stage colors</h3>
                    <p class="mt-1 text-xs text-gray-500">Change the color of each stage. New stages after saving will receive a color from the palette, then they can be tinted here.</p>

                    <div class="mt-3 grid grid-cols-1 gap-3 md:grid-cols-2">
                        @foreach ($pipeline->stages as $stage)
                            <label class="flex items-center justify-between rounded-md border border-gray-200 px-3 py-2">
                                <span class="mr-3 truncate text-sm text-gray-700">{{ $stage->name }}</span>
                                <input
                                    type="color"
                                    name="stage_colors[{{ $stage->id }}]"
                                    value="{{ $stageColorValues[$stage->id] ?? '#94A3B8' }}"
                                    class="h-9 w-14 rounded-md border border-gray-300 bg-white p-1"
                                >
                            </label>
                        @endforeach
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3">
                    <a href="{{ route('pipelines.index') }}" class="px-4 py-2 text-sm text-gray-700">Cancel</a>
                    <button type="submit" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">Save</button>
                </div>
            </form>

            <form method="POST" action="{{ route('pipelines.destroy', $pipeline) }}" class="text-right" onsubmit="return confirm('Delete funnel?');">
                @csrf
                @method('DELETE')
                <button type="submit" class="text-sm text-red-600 hover:text-red-500">Remove funnel</button>
            </form>
        </div>
    </div>
</x-app-layout>
