@php
    $statusBadgeStyles = [
        'queued' => 'bg-slate-100 text-slate-700',
        'processing' => 'bg-amber-100 text-amber-700',
        'completed' => 'bg-emerald-100 text-emerald-700',
        'failed' => 'bg-rose-100 text-rose-700',
        'skipped' => 'bg-gray-200 text-gray-700',
    ];
@endphp

<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <div>
                <h2 class="text-xl font-semibold leading-tight text-gray-800">{{ __('1C Integration') }}</h2>
                <p class="text-sm text-gray-500">{{ __('Configure synchronization with 1C and monitor exchange queue.') }}</p>
            </div>
            <div class="flex items-center gap-2">
                @include('partials.section-access-controls', [
                    'sectionAccessEntity' => 'onec',
                    'sectionAccessTitle' => __('1C Integration'),
                    'canManageSectionAccess' => $canManageSectionAccess ?? false,
                    'sectionAccessUsers' => $sectionAccessUsers ?? collect(),
                ])
            </div>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full space-y-4 px-6">
            <section class="space-y-4 rounded-xl border border-gray-200 bg-white p-4">
                <div class="flex flex-wrap items-start justify-between gap-3">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">{{ __('1C settings') }}</h3>
                        <p class="text-sm text-gray-500">{{ __('Connection credentials, directions and sync entities.') }}</p>
                    </div>
                    <span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-medium {{ ($settings->is_active ?? false) ? 'bg-emerald-100 text-emerald-700' : 'bg-slate-100 text-slate-600' }}">
                        {{ ($settings->is_active ?? false) ? __('Active') : __('Disabled') }}
                    </span>
                </div>

                <div class="rounded-lg border border-slate-200 bg-slate-50 p-3 text-xs text-slate-600">
                    <div class="flex flex-col gap-1">
                        <span class="font-semibold text-slate-700">{{ __('Webhook URL') }}</span>
                        <code class="break-all rounded bg-white px-2 py-1 text-slate-800">{{ $webhookUrl }}</code>
                        <span>{{ __('Send header') }} <code class="rounded bg-white px-1 py-0.5">X-CRM-Webhook-Secret</code></span>
                    </div>
                </div>

                @if ($canManageSettings)
                    <form method="POST" action="{{ route('onec.settings.update') }}" class="grid grid-cols-1 gap-4">
                        @csrf
                        @method('PATCH')

                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Provider') }}</label>
                                <input
                                    name="provider"
                                    type="text"
                                    value="{{ old('provider', $settings->provider) }}"
                                    class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                    placeholder="1C Enterprise"
                                >
                                <x-input-error class="mt-1" :messages="$errors->get('provider')" />
                            </div>

                            <div class="flex items-end">
                                <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                    <input type="checkbox" name="is_active" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('is_active', $settings->is_active))>
                                    {{ __('Active integration') }}
                                </label>
                                <x-input-error class="mt-1" :messages="$errors->get('is_active')" />
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('API base URL') }}</label>
                                <input
                                    name="endpoint_url"
                                    type="text"
                                    value="{{ old('endpoint_url', $settings->endpoint_url) }}"
                                    class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                    placeholder="https://1c.example.com/exchange"
                                >
                                <x-input-error class="mt-1" :messages="$errors->get('endpoint_url')" />
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Exchange mode') }}</label>
                                <select name="exchange_mode" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    @foreach ($exchangeModeOptions as $value => $label)
                                        <option value="{{ $value }}" @selected(old('exchange_mode', $settings->exchange_mode) === $value)>{{ $label }}</option>
                                    @endforeach
                                </select>
                                <x-input-error class="mt-1" :messages="$errors->get('exchange_mode')" />
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Username') }}</label>
                                <input name="username" type="text" value="{{ old('username', $settings->username) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('username')" />
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Password') }}</label>
                                <input name="password" type="text" value="{{ old('password', $settings->password) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('password')" />
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('API key') }}</label>
                                <input name="api_key" type="text" value="{{ old('api_key', $settings->api_key) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('api_key')" />
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('API secret') }}</label>
                                <input name="api_secret" type="text" value="{{ old('api_secret', $settings->api_secret) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('api_secret')" />
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Webhook secret') }}</label>
                                <input name="webhook_secret" type="text" value="{{ old('webhook_secret', $settings->webhook_secret) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('webhook_secret')" />
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Sync interval (minutes)') }}</label>
                                <input name="sync_interval_minutes" type="number" min="1" max="1440" value="{{ old('sync_interval_minutes', $settings->sync_interval_minutes ?? 15) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('sync_interval_minutes')" />
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-2 md:grid-cols-3">
                            <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                <input type="checkbox" name="auto_sync" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('auto_sync', $settings->auto_sync ?? false))>
                                {{ __('Auto sync') }}
                            </label>
                            <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                <input type="checkbox" name="sync_tasks" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('sync_tasks', $settings->sync_tasks ?? true))>
                                {{ __('Tasks') }}
                            </label>
                            <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                <input type="checkbox" name="sync_deals" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('sync_deals', $settings->sync_deals ?? true))>
                                {{ __('Deals') }}
                            </label>
                            <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                <input type="checkbox" name="sync_companies" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('sync_companies', $settings->sync_companies ?? true))>
                                {{ __('Companies') }}
                            </label>
                            <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                <input type="checkbox" name="sync_contacts" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('sync_contacts', $settings->sync_contacts ?? true))>
                                {{ __('Contacts') }}
                            </label>
                            <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                <input type="checkbox" name="sync_products" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('sync_products', $settings->sync_products ?? true))>
                                {{ __('Products') }}
                            </label>
                            <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                <input type="checkbox" name="sync_warehouses" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('sync_warehouses', $settings->sync_warehouses ?? true))>
                                {{ __('Warehouses') }}
                            </label>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">
                                {{ __('Save settings') }}
                            </button>
                        </div>
                    </form>
                @else
                    <p class="text-sm text-gray-500">{{ __('You do not have rights to edit 1C settings.') }}</p>
                @endif
            </section>

            <section class="space-y-4 rounded-xl border border-gray-200 bg-white p-4">
                <div class="flex flex-wrap items-center justify-between gap-3">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">{{ __('Exchange log') }}</h3>
                        <p class="text-sm text-gray-500">{{ __('Inbound and outbound exchange operations with filtering and retries.') }}</p>
                    </div>
                    <div class="text-xs text-gray-500">{{ __('Total:') }} {{ $exchanges->total() }}</div>
                </div>

                <form method="GET" action="{{ route('onec.index') }}" class="grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-6">
                    <div class="xl:col-span-2">
                        <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Search') }}</label>
                        <input type="text" name="q" value="{{ $search }}" placeholder="{{ __('External ID or error text') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>

                    <div>
                        <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Status') }}</label>
                        <select name="status" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">{{ __('All') }}</option>
                            @foreach ($statusOptions as $value => $label)
                                <option value="{{ $value }}" @selected($status === $value)>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Direction') }}</label>
                        <select name="direction" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">{{ __('All') }}</option>
                            @foreach ($directionOptions as $value => $label)
                                <option value="{{ $value }}" @selected($direction === $value)>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Entity') }}</label>
                        <select name="entity" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">{{ __('All') }}</option>
                            @foreach ($entityOptions as $value => $label)
                                <option value="{{ $value }}" @selected($entity === $value)>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs font-medium uppercase text-gray-500">{{ __('User') }}</label>
                        <x-user-search-select
                            id="onec-user-filter"
                            name="user_id"
                            :users="$userOptions"
                            :selected="$selectedUserId"
                            :placeholder="__('All users')"
                            :empty-label="__('All')"
                        />
                    </div>

                    <div class="flex items-end gap-2">
                        <button type="submit" class="inline-flex items-center rounded-md bg-gray-800 px-4 py-2 text-sm font-medium text-white hover:bg-gray-700">
                            {{ __('Find') }}
                        </button>
                        <a href="{{ route('onec.index') }}" class="inline-flex items-center rounded-md border border-gray-300 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50">
                            {{ __('Reset') }}
                        </a>
                    </div>

                    <div>
                        <label class="block text-xs font-medium uppercase text-gray-500">{{ __('From date') }}</label>
                        <input type="date" name="date_from" value="{{ $dateFrom }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>

                    <div>
                        <label class="block text-xs font-medium uppercase text-gray-500">{{ __('To date') }}</label>
                        <input type="date" name="date_to" value="{{ $dateTo }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                </form>

                @if ($canCreateExchange)
                    <details class="rounded-lg border border-gray-200 bg-gray-50 p-3">
                        <summary class="cursor-pointer text-sm font-medium text-gray-700">{{ __('Create exchange entry') }}</summary>
                        <form method="POST" action="{{ route('onec.exchanges.store') }}" class="mt-3 grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-6">
                            @csrf

                            <div>
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Direction') }}</label>
                                <select name="direction" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    @foreach ($directionOptions as $value => $label)
                                        <option value="{{ $value }}" @selected(old('direction', 'outbound') === $value)>{{ $label }}</option>
                                    @endforeach
                                </select>
                                <x-input-error class="mt-1" :messages="$errors->get('direction')" />
                            </div>

                            <div>
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Entity') }}</label>
                                <select name="entity" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    @foreach ($entityOptions as $value => $label)
                                        <option value="{{ $value }}" @selected(old('entity', 'deals') === $value)>{{ $label }}</option>
                                    @endforeach
                                </select>
                                <x-input-error class="mt-1" :messages="$errors->get('entity')" />
                            </div>

                            <div>
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Action') }}</label>
                                <select name="action" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    @foreach ($actionOptions as $value => $label)
                                        <option value="{{ $value }}" @selected(old('action', 'upsert') === $value)>{{ $label }}</option>
                                    @endforeach
                                </select>
                                <x-input-error class="mt-1" :messages="$errors->get('action')" />
                            </div>

                            <div>
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Status') }}</label>
                                <select name="status" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    @foreach ($statusOptions as $value => $label)
                                        <option value="{{ $value }}" @selected(old('status', 'queued') === $value)>{{ $label }}</option>
                                    @endforeach
                                </select>
                                <x-input-error class="mt-1" :messages="$errors->get('status')" />
                            </div>

                            <div>
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('External ID') }}</label>
                                <input name="external_id" type="text" value="{{ old('external_id') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('external_id')" />
                            </div>

                            <div>
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('User') }}</label>
                                <x-user-search-select
                                    id="onec-user-create"
                                    name="initiated_by_user_id"
                                    :users="$userOptions"
                                    :selected="old('initiated_by_user_id')"
                                    :placeholder="__('Select user')"
                                    :empty-label="__('Not selected')"
                                />
                                <x-input-error class="mt-1" :messages="$errors->get('initiated_by_user_id')" />
                            </div>

                            <div class="md:col-span-2 xl:col-span-3">
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Payload JSON') }}</label>
                                <textarea name="payload" rows="4" class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder='{"crm_id":123,"name":"Demo"}'>{{ old('payload') }}</textarea>
                                <x-input-error class="mt-1" :messages="$errors->get('payload')" />
                            </div>

                            <div class="md:col-span-2 xl:col-span-3">
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Response JSON') }}</label>
                                <textarea name="response" rows="4" class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder='{"status":"ok"}'>{{ old('response') }}</textarea>
                                <x-input-error class="mt-1" :messages="$errors->get('response')" />
                            </div>

                            <div class="md:col-span-2 xl:col-span-3">
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Error message') }}</label>
                                <input name="error_message" type="text" value="{{ old('error_message') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('error_message')" />
                            </div>

                            <div class="md:col-span-2 xl:col-span-3">
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Meta JSON') }}</label>
                                <textarea name="meta" rows="2" class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder='{"source":"manual"}'>{{ old('meta') }}</textarea>
                                <x-input-error class="mt-1" :messages="$errors->get('meta')" />
                            </div>

                            <div class="md:col-span-2 xl:col-span-3">
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Started at') }}</label>
                                <input name="started_at" type="datetime-local" value="{{ old('started_at') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('started_at')" />
                            </div>

                            <div class="md:col-span-2 xl:col-span-3">
                                <label class="block text-xs font-medium uppercase text-gray-500">{{ __('Finished at') }}</label>
                                <input name="finished_at" type="datetime-local" value="{{ old('finished_at') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('finished_at')" />
                            </div>

                            <div class="md:col-span-2 xl:col-span-6 flex justify-end">
                                <button type="submit" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">
                                    {{ __('Create') }}
                                </button>
                            </div>
                        </form>
                    </details>
                @endif

                <div class="overflow-hidden rounded-lg border border-gray-200">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase text-gray-500">{{ __('Direction') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase text-gray-500">{{ __('Entity') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase text-gray-500">{{ __('Action') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase text-gray-500">{{ __('Status') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase text-gray-500">{{ __('External ID') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase text-gray-500">{{ __('User') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase text-gray-500">{{ __('Started') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase text-gray-500">{{ __('Finished') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase text-gray-500">{{ __('Error') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase text-gray-500">{{ __('Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 bg-white">
                            @forelse ($exchanges as $exchange)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $directionOptions[$exchange->direction] ?? ucfirst((string) $exchange->direction) }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $entityOptions[$exchange->entity] ?? ucfirst((string) $exchange->entity) }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $actionOptions[$exchange->action] ?? ucfirst((string) $exchange->action) }}</td>
                                    <td class="px-4 py-3 text-sm">
                                        <span class="inline-flex items-center rounded-full px-2 py-1 text-xs font-medium {{ $statusBadgeStyles[$exchange->status] ?? 'bg-slate-100 text-slate-700' }}">
                                            {{ $statusOptions[$exchange->status] ?? ucfirst((string) $exchange->status) }}
                                        </span>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $exchange->external_id ?: '—' }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">
                                        <div>{{ $exchange->initiatedBy?->name ?? '—' }}</div>
                                        <div class="text-xs text-gray-500">{{ $exchange->initiatedBy?->email ?? '—' }}</div>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $exchange->started_at?->format('d.m.Y H:i') ?? '—' }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $exchange->finished_at?->format('d.m.Y H:i') ?? '—' }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $exchange->error_message ?: '—' }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">
                                        @if ($canUpdateExchange)
                                            <form method="POST" action="{{ route('onec.exchanges.retry', $exchange) }}">
                                                @csrf
                                                @method('PATCH')
                                                <button type="submit" class="inline-flex items-center rounded-md border border-gray-300 px-3 py-1.5 text-xs font-medium text-gray-700 hover:bg-gray-50">
                                                    {{ __('Retry') }}
                                                </button>
                                            </form>
                                        @else
                                            <span class="text-xs text-gray-400">—</span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="10" class="px-4 py-8 text-center text-sm text-gray-500">{{ __('No exchanges found.') }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div>
                    {{ $exchanges->links() }}
                </div>
            </section>
        </div>
    </div>
</x-app-layout>

