<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">News</h2>
                <p class="text-sm text-gray-500">Company news feed</p>
            </div>

            @if ($canCreateNews ?? false)
                <a
                    href="{{ route('news.create') }}"
                    onclick="if (window.crmSidepanel && typeof window.crmSidepanel.open === 'function') { event.preventDefault(); window.crmSidepanel.open(this.href, @js(__('Create news')), { allowAny: true }); }"
                    class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500"
                >
                    {{ __('Create news') }}
                </a>
            @endif
        </div>
    </x-slot>

    <div class="pb-12" data-sidepanel-scope>
        <div class="w-full px-6 space-y-6">
            <section class="rounded-xl border border-gray-200 bg-white">
                <div class="border-b border-gray-100 px-5 py-4">
                    <h3 class="text-sm font-semibold text-gray-900">News feed</h3>
                </div>

                <div class="divide-y divide-gray-100">
                    @forelse ($newsFeed as $news)
                        @php
                            $previewUrl = $news->preview_path
                                ? \Illuminate\Support\Facades\Storage::disk('public')->url($news->preview_path)
                                : null;
                            $viewerList = $newsViewerNames[$news->id] ?? [];
                            $viewerCount = (int) ($news->views_count ?? 0);
                            $viewerRemaining = max(0, $viewerCount - count($viewerList));
                        @endphp
                        <article class="px-5 py-4">
                            <header class="flex items-start justify-between gap-3">
                                <div class="min-w-0">
                                    <h4 class="text-base font-semibold text-gray-900">{{ $news->title }}</h4>
                                    <p class="mt-1 text-xs text-gray-500">
                                        {{ $news->author?->name ?? 'System' }} · {{ $news->published_at?->format('d.m.Y H:i') ?? $news->created_at?->format('d.m.Y H:i') }}
                                    </p>
                                </div>

                                <div class="relative group ml-auto inline-flex shrink-0 items-center gap-1 text-xs text-slate-500">
                                    <x-menu-icon name="fa-solid fa-eye" class="h-3.5 w-3.5" />
                                    <span>{{ $viewerCount }}</span>
                                    <div class="pointer-events-none absolute right-0 top-full z-10 mt-2 hidden min-w-[180px] rounded-md border border-slate-200 bg-white p-2 text-xs text-slate-700 shadow-lg group-hover:block">
                                        <p class="mb-1 text-[11px] font-semibold uppercase tracking-wide text-slate-400">{{ __('Viewed by') }}</p>
                                        @if ($viewerCount === 0)
                                            <p class="text-slate-500">{{ __('No views yet') }}</p>
                                        @else
                                            <ul class="space-y-1">
                                                @foreach ($viewerList as $viewerName)
                                                    <li class="truncate">{{ $viewerName }}</li>
                                                @endforeach
                                                @if ($viewerRemaining > 0)
                                                    <li class="text-slate-400">{{ __('+ :count more', ['count' => $viewerRemaining]) }}</li>
                                                @endif
                                            </ul>
                                        @endif
                                    </div>
                                </div>
                            </header>

                            @if ($previewUrl)
                                <div class="mt-3 overflow-hidden rounded-lg border border-slate-200 bg-slate-50">
                                    <img src="{{ $previewUrl }}" alt="{{ $news->title }}" class="h-auto w-full object-cover">
                                </div>
                            @endif

                            <p class="mt-3 whitespace-pre-line text-sm leading-6 text-gray-700">{{ $news->content }}</p>
                        </article>
                    @empty
                        <div class="px-5 py-10 text-center text-sm text-gray-500">No news yet. Publish the first news.</div>
                    @endforelse
                </div>

                <div class="border-t border-gray-100 px-5 py-4">
                    {{ $newsFeed->links() }}
                </div>
            </section>
        </div>
    </div>
</x-app-layout>
