<x-guest-layout>
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <div class="mb-4">
        <h1 class="text-lg font-semibold text-gray-900">{{ __('Enter one-time code or recovery code') }}</h1>
        <p class="mt-1 text-sm text-gray-600">{{ __('Use your authenticator application to confirm access.') }}</p>
    </div>

    <form method="POST" action="{{ route('two-factor.verify') }}" class="space-y-4">
        @csrf

        <div>
            <x-input-label for="code" :value="__('Verification code')" />
            <x-text-input
                id="code"
                class="mt-1 block w-full"
                type="text"
                name="code"
                :value="old('code')"
                required
                autofocus
                autocomplete="one-time-code"
            />
            <x-input-error :messages="$errors->get('code')" class="mt-2" />
        </div>

        <div class="flex items-center justify-between gap-4">
            <a href="{{ route('login') }}" class="text-sm text-gray-600 underline hover:text-gray-900">{{ __('Back to login') }}</a>

            <x-primary-button>
                {{ __('Confirm code') }}
            </x-primary-button>
        </div>
    </form>
</x-guest-layout>
