<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Editing an Activity</h2>
            <a href="{{ route('activities.show', $activity) }}" class="text-sm text-indigo-600 hover:text-indigo-500">Open card</a>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-4">
            <form method="POST" action="{{ route('activities.update', $activity) }}" class="bg-white border border-gray-200 rounded-xl p-6">
                @csrf
                @method('PUT')
                @include('activities._form')

                <div class="mt-6 flex items-center justify-end gap-3">
                    <a href="{{ route('activities.show', $activity) }}" class="px-4 py-2 text-sm text-gray-700">Cancel</a>
                    <button type="submit" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">Save</button>
                </div>
            </form>

            <form method="POST" action="{{ route('activities.destroy', $activity) }}" class="text-right" onsubmit="return confirm('Delete activity?');">
                @csrf
                @method('DELETE')
                <button type="submit" class="text-sm text-red-600 hover:text-red-500">Delete activity</button>
            </form>
        </div>
    </div>
</x-app-layout>
