@php
    $activity = $activity ?? null;
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label for="type" class="block text-sm font-medium text-gray-700">Type</label>
        <select id="type" name="type" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach (['call' => 'Call', 'email' => 'Email', 'meeting' => 'Meeting', 'note' => 'Note', 'task_update' => 'Task update'] as $value => $label)
                <option value="{{ $value }}" @selected(old('type', $activity?->type ?? 'note') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="direction" class="block text-sm font-medium text-gray-700">Direction</label>
        <select id="direction" name="direction" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach (['internal' => 'Internal', 'inbound' => 'Inbound', 'outbound' => 'Outbound'] as $value => $label)
                <option value="{{ $value }}" @selected(old('direction', $activity?->direction ?? 'internal') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div class="md:col-span-2">
        <label for="subject" class="block text-sm font-medium text-gray-700">Subject</label>
        <input id="subject" name="subject" type="text" required value="{{ old('subject', $activity?->subject) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="occurred_at" class="block text-sm font-medium text-gray-700">Date/time</label>
        <input id="occurred_at" name="occurred_at" type="datetime-local" required value="{{ old('occurred_at', request('occurred_at', $activity?->occurred_at?->format('Y-m-d\TH:i') ?? now()->format('Y-m-d\TH:i'))) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="outcome" class="block text-sm font-medium text-gray-700">Result</label>
        <input id="outcome" name="outcome" type="text" value="{{ old('outcome', $activity?->outcome) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="deal_id" class="block text-sm font-medium text-gray-700">Deal</label>
        <select id="deal_id" name="deal_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            <option value="">No binding</option>
            @foreach ($deals as $deal)
                <option value="{{ $deal->id }}" @selected((int) old('deal_id', request('deal_id', $activity?->deal_id)) === $deal->id)>{{ $deal->title }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="company_id" class="block text-sm font-medium text-gray-700">Company</label>
        <select id="company_id" name="company_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            <option value="">No binding</option>
            @foreach ($companies as $company)
                <option value="{{ $company->id }}" @selected((int) old('company_id', request('company_id', $activity?->company_id)) === $company->id)>{{ $company->name }}</option>
            @endforeach
        </select>
    </div>

    <div class="md:col-span-2">
        <label for="contact_id" class="block text-sm font-medium text-gray-700">Contact</label>
        <select id="contact_id" name="contact_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            <option value="">No binding</option>
            @foreach ($contacts as $contact)
                <option value="{{ $contact->id }}" @selected((int) old('contact_id', request('contact_id', $activity?->contact_id)) === $contact->id)>{{ $contact->full_name ?: $contact->first_name }}</option>
            @endforeach
        </select>
    </div>
</div>

<div class="mt-4">
    <label for="details" class="block text-sm font-medium text-gray-700">Details</label>
    <textarea id="details" name="details" rows="4" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('details', $activity?->details) }}</textarea>
</div>
