# Redis and Hot Cache

## What is already implemented

- Safe Redis connection parameters in `config/database.php`:
  - `REDIS_SCHEME`
  - `REDIS_TIMEOUT` / `REDIS_READ_TIMEOUT`
  - TLS verification flags:
    - `REDIS_SSL_VERIFY_PEER`
    - `REDIS_SSL_VERIFY_PEER_NAME`
    - `REDIS_SSL_ALLOW_SELF_SIGNED`
- Dedicated hot cache store in `config/cache.php`:
  - `HOT_CACHE_STORE=hot`
  - `hot` store is a failover chain (`HOT_CACHE_FAILOVER_STORES`)

## Hot data moved to cache

- Sidebar menu payload (per user + locale, with invalidation on updates):
  - `App\Support\MenuManager`
- Sidebar brand data (name/logo, with invalidation on company settings changes):
  - `App\Support\BrandingManager`

## Safe local setup

Use fallback without Redis:

```env
HOT_CACHE_STORE=hot
HOT_CACHE_FAILOVER_STORES=database,array
```

## Redis-enabled setup (recommended for production)

```env
HOT_CACHE_STORE=hot
HOT_CACHE_FAILOVER_STORES=redis,database,array

REDIS_CLIENT=phpredis
REDIS_SCHEME=tls
REDIS_HOST=your-redis-host
REDIS_PORT=6379
REDIS_USERNAME=default
REDIS_PASSWORD=strong-secret
REDIS_DB=0
REDIS_CACHE_DB=1
REDIS_TIMEOUT=2.0
REDIS_READ_TIMEOUT=2.0
REDIS_SSL_VERIFY_PEER=true
REDIS_SSL_VERIFY_PEER_NAME=true
REDIS_SSL_ALLOW_SELF_SIGNED=false
```

## Apply config

```bash
php artisan config:clear
php artisan cache:clear
```
