# API CRM (v1)

REST API documentation for the mobile client and external integrations.

## API Base

- Base URL: `/api/v1`
- Format: `application/json`
- Authentication: Laravel Sanctum Bearer token

Example headers:

```http
Accept: application/json
Content-Type: application/json
Authorization: Bearer <TOKEN>
```

## Authentication

### Get token

`POST /api/v1/auth/login`

Request body:

```json
{
  "email": "admin@crm.local",
  "password": "password",
  "device_name": "ios-app"
}
```

Successful response:

```json
{
  "token": "1|xxxxxxxxxxxxxxxx",
  "token_type": "Bearer",
  "user": {
    "data": {
      "id": 1,
      "name": "CRM Admin",
      "email": "admin@crm.local",
      "role": "admin"
    }
  }
}
```

### Current user profile

`GET /api/v1/auth/me`

### Revoke current token

`POST /api/v1/auth/logout`

## Role and Permission Access

Roles allowed to access API login: `admin`, `manager`, `sales`.

Each token from profile settings can receive granular abilities:

| Module | Read | Create | Update | Delete |
| --- | --- | --- | --- | --- |
| Tasks | `tasks.read` | `tasks.create` | `tasks.update` | `tasks.delete` |
| Deals | `deals.read` | `deals.create` | `deals.update` | `deals.delete` |
| Products | `products.read` | `products.create` | `products.update` | `products.delete` |
| Warehouses | `warehouses.read` | `warehouses.create` | `warehouses.update` | `warehouses.delete` |
| HR Service | `hr.read` | `hr.create` | `hr.update` | `hr.delete` |
| Telephony | `telephony.read` | `telephony.create` | `telephony.update` | `telephony.delete` |
| Messengers | `messengers.read` | `messengers.create` | `messengers.update` | `messengers.delete` |
| Mail Service | `mail.read` | `mail.create` | `mail.update` | `mail.delete` |
| Companies | `companies.read` | `companies.create` | `companies.update` | `companies.delete` |
| Contacts | `contacts.read` | `contacts.create` | `contacts.update` | `contacts.delete` |
| Projects | `projects.read` | `projects.create` | `projects.update` | `projects.delete` |
| Disk | `disks.read` | `disks.create` | `disks.update` | `disks.delete` |
| 1C Integration | `onec.read` | `onec.create` | `onec.update` | `onec.delete` |

If a token does not have the required ability, the API returns `403`.

## Custom Modules

You can extend CRM behavior with custom ZIP modules.

Each module archive must contain `module.json` in archive root and PHP hook scripts.

Supported runtime hooks are listed in `docs/modules.md` and on the Modules documentation page.

Install and manage modules in `Profile -> Modules`.

Full guide is available in [docs/modules.md](modules.md).

## Endpoints

### Companies

- `GET /api/v1/companies` (`companies.read`)
- `POST /api/v1/companies` (`companies.create`)
- `GET /api/v1/companies/{company}` (`companies.read`)
- `PATCH /api/v1/companies/{company}` (`companies.update`)
- `DELETE /api/v1/companies/{company}` (`companies.delete`)

Main create/update fields:

`name`, `status`, `industry`, `website`, `phone`, `email`, `address`, `owner_id`, `source`, `notes`

Company statuses: `lead`, `client`, `partner`, `inactive`.

### Contacts

- `GET /api/v1/contacts` (`contacts.read`)
- `POST /api/v1/contacts` (`contacts.create`)
- `GET /api/v1/contacts/{contact}` (`contacts.read`)
- `PATCH /api/v1/contacts/{contact}` (`contacts.update`)
- `DELETE /api/v1/contacts/{contact}` (`contacts.delete`)

Main fields:

`first_name`, `last_name`, `title`, `email`, `phone`, `company_id`, `owner_id`, `source`, `last_contacted_at`, `notes`

### Deals

- `GET /api/v1/deals` (`deals.read`)
- `POST /api/v1/deals` (`deals.create`)
- `GET /api/v1/deals/{deal}` (`deals.read`)
- `PATCH /api/v1/deals/{deal}` (`deals.update`)
- `DELETE /api/v1/deals/{deal}` (`deals.delete`)
- `PATCH /api/v1/deals/{deal}/stage` (`deals.update`)

Main fields:

`title`, `pipeline_id`, `stage_id`, `company_id`, `contact_id`, `owner_id`, `amount`, `currency`, `priority`, `status`, `expected_close_at`, `source`, `lost_reason`, `description`

Deal priority: `low`, `medium`, `high`.

Deal statuses: `open`, `won`, `lost`.

### Products

- `GET /api/v1/products` (`products.read`)
- `POST /api/v1/products` (`products.create`)
- `GET /api/v1/products/{product}` (`products.read`)
- `PATCH /api/v1/products/{product}` (`products.update`)
- `DELETE /api/v1/products/{product}` (`products.delete`)

Main fields:

`name`, `sku`, `price`, `currency`, `unit`, `stock`, `status`, `company_id`, `owner_id`, `description`

Product status: `active`, `archived`.

### Warehouses

- `GET /api/v1/warehouses` (`warehouses.read`)
- `POST /api/v1/warehouses` (`warehouses.create`)
- `GET /api/v1/warehouses/{warehouse}` (`warehouses.read`)
- `PATCH /api/v1/warehouses/{warehouse}` (`warehouses.update`)
- `DELETE /api/v1/warehouses/{warehouse}` (`warehouses.delete`)

Main fields:

`name`, `code`, `location`, `capacity`, `status`, `manager_id`, `description`

Warehouse statuses: `active`, `inactive`.

### Tasks

- `GET /api/v1/tasks` (`tasks.read`)
- `POST /api/v1/tasks` (`tasks.create`)
- `GET /api/v1/tasks/{task}` (`tasks.read`)
- `PATCH /api/v1/tasks/{task}` (`tasks.update`)
- `DELETE /api/v1/tasks/{task}` (`tasks.delete`)
- `PATCH /api/v1/tasks/{task}/status` (`tasks.update`)
- `PATCH /api/v1/tasks/{task}/complete` (`tasks.update`)

Main fields:

`title`, `description`, `deal_id`, `company_id`, `contact_id`, `project_id`, `project_stage_id`, `parent_id`, `assignee_id`, `status`, `priority`, `estimated_hours`, `tracked_hours`, `sort_order`, `starts_at`, `due_at`, `reminder_at`

Task statuses: `todo`, `in_progress`, `review`, `done`.

Task priority: `low`, `medium`, `high`, `urgent`.

### Projects

- `GET /api/v1/projects` (`projects.read`)
- `POST /api/v1/projects` (`projects.create`)
- `GET /api/v1/projects/{project}` (`projects.read`)
- `PATCH /api/v1/projects/{project}` (`projects.update`)
- `DELETE /api/v1/projects/{project}` (`projects.delete`)
- `PATCH /api/v1/projects/{project}/tasks/{task}/stage` (`projects.update`)

Main fields:

`name`, `code`, `description`, `company_id`, `deal_id`, `owner_id`, `manager_id`, `status`, `priority`, `health`, `budget`, `spent`, `starts_at`, `due_at`, `visibility`, `notes`

Project status: `planned`, `active`, `on_hold`, `completed`, `cancelled`.

Project priority: `low`, `medium`, `high`, `critical`.

Health: `normal`, `warning`, `risk`.

Visibility: `team`, `private`, `public`.

### Disk

- `GET /api/v1/disks` (`disks.read`)
- `POST /api/v1/disks` (`disks.create`)
- `GET /api/v1/disks/{disk}` (`disks.read`)
- `PATCH /api/v1/disks/{disk}` (`disks.update`)
- `DELETE /api/v1/disks/{disk}` (`disks.delete`)
- `GET /api/v1/disks/{disk}/download` (`disks.read`)

Main fields:

`file` (multipart), `name`, `folder`, `description`, `is_public`

### HR Service

- `GET /api/v1/hr/settings` (`hr.read`)
- `PATCH /api/v1/hr/settings` (`hr.update`)
- `GET /api/v1/hr/requests` (`hr.read`)
- `POST /api/v1/hr/requests` (`hr.create`)
- `GET /api/v1/hr/requests/{hrRequest}` (`hr.read`)
- `PATCH /api/v1/hr/requests/{hrRequest}` (`hr.update`)
- `DELETE /api/v1/hr/requests/{hrRequest}` (`hr.delete`)

HR request main fields:

`type`, `status`, `priority`, `title`, `description`, `requested_date`, `due_date`, `resolved_date`, `employee_user_id`, `assignee_user_id`, `creator_user_id`, `external_id`, `meta`

HR settings fields:

`provider`, `is_active`, `api_base_url`, `api_key`, `api_secret`, `webhook_secret`, `auto_assign_user_id`, `default_sla_days`, `allow_employee_requests`, `require_approval`, `meta`

### Telephony

- `GET /api/v1/telephony/settings` (`telephony.read`)
- `PATCH /api/v1/telephony/settings` (`telephony.update`)
- `GET /api/v1/telephony/calls` (`telephony.read`)
- `POST /api/v1/telephony/calls` (`telephony.create`)
- `GET /api/v1/telephony/calls/{call}` (`telephony.read`)
- `PATCH /api/v1/telephony/calls/{call}` (`telephony.update`)
- `DELETE /api/v1/telephony/calls/{call}` (`telephony.delete`)

Call main fields:

`direction`, `from_number`, `to_number`, `status`, `duration_seconds`, `started_at`, `ended_at`, `recording_url`, `external_id`, `user_id`, `meta`

Settings fields:

`provider`, `is_active`, `api_base_url`, `api_key`, `api_secret`, `account_id`, `inbound_number`, `outbound_number`, `webhook_secret`

### Messengers

- `GET /api/v1/messengers/settings` (`messengers.read`)
- `PATCH /api/v1/messengers/settings` (`messengers.update`)
- `GET /api/v1/messengers/channels` (`messengers.read`)
- `POST /api/v1/messengers/channels` (`messengers.create`)
- `GET /api/v1/messengers/channels/{channel}` (`messengers.read`)
- `PATCH /api/v1/messengers/channels/{channel}` (`messengers.update`)
- `DELETE /api/v1/messengers/channels/{channel}` (`messengers.delete`)
- `GET /api/v1/messengers/conversations` (`messengers.read`)
- `POST /api/v1/messengers/conversations` (`messengers.create`)
- `GET /api/v1/messengers/conversations/{conversation}` (`messengers.read`)
- `PATCH /api/v1/messengers/conversations/{conversation}` (`messengers.update`)
- `DELETE /api/v1/messengers/conversations/{conversation}` (`messengers.delete`)
- `GET /api/v1/messengers/conversations/{conversation}/messages` (`messengers.read`)
- `POST /api/v1/messengers/conversations/{conversation}/messages` (`messengers.create`)
- `GET /api/v1/messengers/messages/{message}` (`messengers.read`)
- `PATCH /api/v1/messengers/messages/{message}` (`messengers.update`)
- `DELETE /api/v1/messengers/messages/{message}` (`messengers.delete`)

Main fields:

Channels: `provider`, `name`, `handle`, `external_id`, `status`, `is_default`, `meta`

Conversations: `channel_id`, `contact_name`, `contact_handle`, `status`, `external_id`, `user_id`, `meta`

Messages: `direction`, `body`, `attachments`, `status`, `sent_at`, `external_id`, `user_id`, `meta`

Settings fields:

`provider`, `is_active`, `api_base_url`, `api_key`, `api_secret`, `account_id`, `webhook_secret`

### Mail Service

- `GET /api/v1/mail/settings` (`mail.read`)
- `PATCH /api/v1/mail/settings` (`mail.update`)
- `GET /api/v1/mail/mailboxes` (`mail.read`)
- `POST /api/v1/mail/mailboxes` (`mail.create`)
- `GET /api/v1/mail/mailboxes/{mailbox}` (`mail.read`)
- `PATCH /api/v1/mail/mailboxes/{mailbox}` (`mail.update`)
- `DELETE /api/v1/mail/mailboxes/{mailbox}` (`mail.delete`)

Main mailbox fields:

`user_id`, `local_part`, `domain`, `status`, `is_primary`, `quota_mb`, `used_mb`, `forward_to`, `password`, `meta`

Mail settings fields:

`provider`, `is_active`, `domain`, `api_base_url`, `api_key`, `api_secret`, `account_id`, `webhook_secret`, `auto_provision_on_registration`, `auto_provision_on_user_create`, `default_status`, `default_quota_mb`

### 1C Integration

- `GET /api/v1/onec/settings` (`onec.read`)
- `PATCH /api/v1/onec/settings` (`onec.update`)
- `GET /api/v1/onec/exchanges` (`onec.read`)
- `POST /api/v1/onec/exchanges` (`onec.create`)
- `GET /api/v1/onec/exchanges/{exchange}` (`onec.read`)
- `PATCH /api/v1/onec/exchanges/{exchange}` (`onec.update`)
- `PATCH /api/v1/onec/exchanges/{exchange}/retry` (`onec.update`)
- `DELETE /api/v1/onec/exchanges/{exchange}` (`onec.delete`)

Main settings fields:

`provider`, `is_active`, `endpoint_url`, `username`, `password`, `api_key`, `api_secret`, `webhook_secret`, `exchange_mode`, `auto_sync`, `sync_tasks`, `sync_deals`, `sync_companies`, `sync_contacts`, `sync_products`, `sync_warehouses`, `sync_interval_minutes`

Main exchange fields:

`external_id`, `direction`, `entity`, `action`, `status`, `payload`, `response`, `error_message`, `started_at`, `finished_at`, `initiated_by_user_id`, `meta`

## Filters

### Tasks

`q`, `status`, `priority`, `assignee_id`, `creator_id`, `project_id`, `parent_id`, `deadline`, `mine`

`deadline`: `overdue`, `today`, `week`

### Deals

`pipeline_id`, `status`, `q`

### Companies / Contacts / Projects

`q` and additional module-specific status filters.

### Products

`q`, `status`, `company_id`, `owner_id`

### Warehouses

`q`, `status`, `manager_id`

### Disk

`q`, `folder`, `owner_id`

### HR Service

`q`, `type`, `status`, `priority`, `user_id`, `date_from`, `date_to`

### Telephony

`q`, `direction`, `status`, `user_id`, `date_from`, `date_to`

### Messengers

`q`, `status`, `provider`, `channel_id`, `user_id`, `date_from`, `date_to`

### Mail Service

`q`, `status`, `domain`, `user_id`

### 1C Integration

`q`, `status`, `direction`, `entity`, `user_id`, `date_from`, `date_to`

## JSON Examples

### Create task: JSON request

`POST /api/v1/tasks`

```json
{
  "title": "Prepare a commercial proposal",
  "description": "Align estimate and delivery timeline",
  "status": "todo",
  "priority": "high",
  "assignee_id": 7,
  "project_id": 3,
  "due_at": "2026-03-05T18:00:00+03:00",
  "estimated_hours": 6
}
```

### Create task: JSON response

```json
{
  "data": {
    "id": 154,
    "title": "Prepare a commercial proposal",
    "status": "todo",
    "priority": "high",
    "estimated_hours": 6,
    "tracked_hours": 0,
    "project": {
      "id": 3,
      "name": "CRM Upgrade"
    },
    "assignee": {
      "id": 7,
      "name": "John Smith",
      "email": "john@crm.local",
      "role": "manager"
    },
    "created_at": "2026-02-27T12:00:00.000000Z",
    "updated_at": "2026-02-27T12:00:00.000000Z"
  }
}
```

### Validation error: JSON response (`422`)

```json
{
  "message": "The title field is required. (and 1 more error)",
  "errors": {
    "title": [
      "The title field is required."
    ],
    "status": [
      "The selected status is invalid."
    ]
  }
}
```

## cURL Examples

### Login and get token

```bash
curl -X POST http://localhost/api/v1/auth/login \
  -H "Accept: application/json" \
  -H "Content-Type: application/json" \
  -d '{
    "email":"admin@crm.local",
    "password":"password",
    "device_name":"mobile-app"
  }'
```

### Get tasks list

```bash
curl "http://localhost/api/v1/tasks?status=in_progress&mine=1" \
  -H "Accept: application/json" \
  -H "Authorization: Bearer <TOKEN>"
```

### Move task to review

```bash
curl -X PATCH http://localhost/api/v1/tasks/15/status \
  -H "Accept: application/json" \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer <TOKEN>" \
  -d '{"status":"review"}'
```

### Change deal stage

```bash
curl -X PATCH http://localhost/api/v1/deals/9/stage \
  -H "Accept: application/json" \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer <TOKEN>" \
  -d '{"stage_id":31}'
```

## Errors

- `401` token is missing or invalid.
- `403` user or token has no permission.
- `422` validation error.
- `404` entity not found.
