<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('update_installations', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('update_setting_id')->constrained('update_settings')->cascadeOnDelete();
            $table->foreignId('update_check_id')->nullable()->constrained('update_checks')->nullOnDelete();
            $table->foreignId('actor_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('status', 32)->default('failed');
            $table->string('target_version')->nullable();
            $table->string('target_build')->nullable();
            $table->string('package_url')->nullable();
            $table->string('package_name')->nullable();
            $table->string('package_path')->nullable();
            $table->string('backup_path')->nullable();
            $table->string('checksum_sha256', 128)->nullable();
            $table->text('message')->nullable();
            $table->json('events')->nullable();
            $table->timestamp('started_at')->nullable();
            $table->timestamp('finished_at')->nullable();
            $table->timestamps();

            $table->index(['status', 'started_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('update_installations');
    }
};
