<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('one_c_settings', function (Blueprint $table): void {
            $table->id();
            $table->string('provider')->default('1c');
            $table->boolean('is_active')->default(false);
            $table->string('endpoint_url')->nullable();
            $table->string('username')->nullable();
            $table->string('password')->nullable();
            $table->string('api_key')->nullable();
            $table->string('api_secret')->nullable();
            $table->string('webhook_secret')->nullable();
            $table->string('exchange_mode', 32)->default('bidirectional');
            $table->boolean('auto_sync')->default(false);
            $table->boolean('sync_tasks')->default(true);
            $table->boolean('sync_deals')->default(true);
            $table->boolean('sync_companies')->default(true);
            $table->boolean('sync_contacts')->default(true);
            $table->boolean('sync_products')->default(true);
            $table->boolean('sync_warehouses')->default(true);
            $table->unsignedInteger('sync_interval_minutes')->default(15);
            $table->timestamp('last_sync_at')->nullable()->index();
            $table->json('meta')->nullable();
            $table->timestamps();

            $table->index('provider');
            $table->index('is_active');
            $table->index('exchange_mode');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('one_c_settings');
    }
};

