<?php

namespace Database\Factories;

use App\Models\Disk;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends Factory<Disk>
 */
class DiskFactory extends Factory
{
    protected $model = Disk::class;

    /**
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $filename = Str::slug($this->faker->words(2, true)).'.txt';

        return [
            'name' => pathinfo($filename, PATHINFO_FILENAME),
            'original_name' => $filename,
            'storage_path' => 'disk/'.$this->faker->uuid().'.txt',
            'folder' => $this->faker->optional()->randomElement(['shared', 'sales', 'contracts']),
            'mime_type' => 'text/plain',
            'extension' => 'txt',
            'size' => $this->faker->numberBetween(128, 65535),
            'description' => $this->faker->optional()->sentence(),
            'is_public' => $this->faker->boolean(20),
            'owner_id' => User::factory(),
        ];
    }
}
