<?php

namespace App\Policies;

use App\Models\Product;
use App\Models\User;
use App\Support\AccessControl;

class ProductPolicy
{
    public function viewAny(User $user): bool
    {
        return AccessControl::allows($user, 'products', 'read');
    }

    public function view(User $user, Product $product): bool
    {
        return AccessControl::allows($user, 'products', 'read');
    }

    public function create(User $user): bool
    {
        return AccessControl::allows($user, 'products', 'create');
    }

    public function update(User $user, Product $product): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'products', 'update');
        if ($decision !== null) {
            return $decision;
        }

        if (! AccessControl::roleAllows($user, 'products', 'update')) {
            return false;
        }

        return AccessControl::isElevated($user) || $product->owner_id === $user->id;
    }

    public function delete(User $user, Product $product): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'products', 'delete');
        if ($decision !== null) {
            return $decision;
        }

        if (! AccessControl::roleAllows($user, 'products', 'delete')) {
            return false;
        }

        return AccessControl::isElevated($user);
    }
}
