<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class OrganizationCompany extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'logo_path',
        'requisites',
        'address',
        'phones',
        'sort_order',
        'parent_id',
    ];

    protected function casts(): array
    {
        return [
            'phones' => 'array',
            'sort_order' => 'integer',
            'parent_id' => 'integer',
        ];
    }

    public function users(): HasMany
    {
        return $this->hasMany(User::class, 'organization_company_id');
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(self::class, 'parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(self::class, 'parent_id');
    }

    public function phonesAsText(): string
    {
        $phones = is_array($this->phones) ? $this->phones : [];

        return implode(PHP_EOL, array_values(array_filter(
            array_map(static fn ($value) => trim((string) $value), $phones),
            static fn (string $value) => $value !== ''
        )));
    }
}
