<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\Warehouse */
class WarehouseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'code' => $this->code,
            'location' => $this->location,
            'capacity' => (float) $this->capacity,
            'status' => $this->status,
            'description' => $this->description,
            'map_rows' => (int) ($this->map_rows ?? 0),
            'map_columns' => (int) ($this->map_columns ?? 0),
            'manager' => UserResource::make($this->whenLoaded('manager')),
            'addresses' => WarehouseAddressResource::collection($this->whenLoaded('addresses')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
