<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\Project */
class ProjectResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'code' => $this->code,
            'description' => $this->description,
            'status' => $this->status,
            'priority' => $this->priority,
            'health' => $this->health,
            'progress' => $this->progress,
            'budget' => (float) $this->budget,
            'spent' => (float) $this->spent,
            'starts_at' => $this->starts_at,
            'due_at' => $this->due_at,
            'completed_at' => $this->completed_at,
            'visibility' => $this->visibility,
            'notes' => $this->notes,
            'company' => CompanyResource::make($this->whenLoaded('company')),
            'deal' => DealResource::make($this->whenLoaded('deal')),
            'owner' => UserResource::make($this->whenLoaded('owner')),
            'manager' => UserResource::make($this->whenLoaded('manager')),
            'members' => UserResource::collection($this->whenLoaded('members')),
            'tasks_count' => $this->whenCounted('tasks'),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
