<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\MailServiceSetting */
class MailServiceSettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'provider' => $this->provider,
            'is_active' => (bool) $this->is_active,
            'domain' => $this->domain,
            'api_base_url' => $this->api_base_url,
            'api_key' => $this->api_key,
            'api_secret' => $this->api_secret,
            'account_id' => $this->account_id,
            'webhook_secret' => $this->webhook_secret,
            'auto_provision_on_registration' => (bool) ($this->auto_provision_on_registration ?? false),
            'auto_provision_on_user_create' => (bool) ($this->auto_provision_on_user_create ?? false),
            'default_status' => $this->default_status,
            'default_quota_mb' => (int) ($this->default_quota_mb ?? 0),
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}

