<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\Deal */
class DealResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'amount' => (float) $this->amount,
            'currency' => $this->currency,
            'priority' => $this->priority,
            'status' => $this->status,
            'expected_close_at' => $this->expected_close_at,
            'closed_at' => $this->closed_at,
            'last_activity_at' => $this->last_activity_at,
            'source' => $this->source,
            'lost_reason' => $this->lost_reason,
            'description' => $this->description,
            'pipeline' => [
                'id' => $this->pipeline_id,
                'name' => $this->whenLoaded('pipeline', fn () => $this->pipeline?->name),
            ],
            'stage' => [
                'id' => $this->stage_id,
                'name' => $this->whenLoaded('stage', fn () => $this->stage?->name),
                'color' => $this->whenLoaded('stage', fn () => $this->stage?->color),
                'is_won' => $this->whenLoaded('stage', fn () => $this->stage?->is_won),
                'is_lost' => $this->whenLoaded('stage', fn () => $this->stage?->is_lost),
            ],
            'company' => CompanyResource::make($this->whenLoaded('company')),
            'contact' => ContactResource::make($this->whenLoaded('contact')),
            'owner' => UserResource::make($this->whenLoaded('owner')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
