<?php

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CompanyController;
use App\Http\Controllers\Api\ContactController;
use App\Http\Controllers\Api\DealController;
use App\Http\Controllers\Api\DiskController;
use App\Http\Controllers\Api\HrRequestController;
use App\Http\Controllers\Api\HrSettingsController;
use App\Http\Controllers\Api\MailSettingsController;
use App\Http\Controllers\Api\MailboxController;
use App\Http\Controllers\Api\MessengerChannelController;
use App\Http\Controllers\Api\MessengerConversationController;
use App\Http\Controllers\Api\MessengerMessageController;
use App\Http\Controllers\Api\MessengerSettingsController;
use App\Http\Controllers\Api\OneCExchangeController;
use App\Http\Controllers\Api\OneCSettingsController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\ProjectController;
use App\Http\Controllers\Api\TaskController;
use App\Http\Controllers\Api\TelephonyCallController;
use App\Http\Controllers\Api\TelephonySettingsController;
use App\Http\Controllers\Api\UpdateCenterController;
use App\Http\Controllers\Api\WarehouseController;
use App\Http\Controllers\Api\WarehouseAddressController;
use App\Http\Controllers\MessengerWebhookController;
use App\Http\Controllers\OneCWebhookController;
use App\Http\Controllers\TelephonyWebhookController;
use App\Http\Controllers\HrWebhookController;
use Illuminate\Support\Facades\Route;

Route::post('/webhooks/telephony', [TelephonyWebhookController::class, 'handle'])->name('telephony.webhook');
Route::post('/webhooks/messengers', [MessengerWebhookController::class, 'handle'])->name('messengers.webhook');
Route::post('/webhooks/onec', [OneCWebhookController::class, 'handle'])->name('onec.webhook');
Route::post('/webhooks/hr', [HrWebhookController::class, 'handle'])->name('hr.webhook');

Route::prefix('v1')->name('api.v1.')->group(function () {
    Route::post('/auth/login', [AuthController::class, 'login']);

    Route::middleware(['auth:sanctum', 'can:accessApi'])->group(function () {
        Route::get('/auth/me', [AuthController::class, 'me']);
        Route::post('/auth/logout', [AuthController::class, 'logout']);

        Route::get('companies', [CompanyController::class, 'index'])->middleware('token.ability:companies.read');
        Route::post('companies', [CompanyController::class, 'store'])->middleware('token.ability:companies.create');
        Route::get('companies/{company}', [CompanyController::class, 'show'])->middleware('token.ability:companies.read');
        Route::match(['put', 'patch'], 'companies/{company}', [CompanyController::class, 'update'])->middleware('token.ability:companies.update');
        Route::delete('companies/{company}', [CompanyController::class, 'destroy'])->middleware('token.ability:companies.delete');

        Route::get('contacts', [ContactController::class, 'index'])->middleware('token.ability:contacts.read');
        Route::post('contacts', [ContactController::class, 'store'])->middleware('token.ability:contacts.create');
        Route::get('contacts/{contact}', [ContactController::class, 'show'])->middleware('token.ability:contacts.read');
        Route::match(['put', 'patch'], 'contacts/{contact}', [ContactController::class, 'update'])->middleware('token.ability:contacts.update');
        Route::delete('contacts/{contact}', [ContactController::class, 'destroy'])->middleware('token.ability:contacts.delete');

        Route::get('deals', [DealController::class, 'index'])->middleware('token.ability:deals.read');
        Route::post('deals', [DealController::class, 'store'])->middleware('token.ability:deals.create');
        Route::get('deals/{deal}', [DealController::class, 'show'])->middleware('token.ability:deals.read');
        Route::match(['put', 'patch'], 'deals/{deal}', [DealController::class, 'update'])->middleware('token.ability:deals.update');
        Route::delete('deals/{deal}', [DealController::class, 'destroy'])->middleware('token.ability:deals.delete');
        Route::patch('deals/{deal}/stage', [DealController::class, 'updateStage'])->middleware('token.ability:deals.update');

        Route::get('products', [ProductController::class, 'index'])->middleware('token.ability:products.read');
        Route::post('products', [ProductController::class, 'store'])->middleware('token.ability:products.create');
        Route::get('products/{product}', [ProductController::class, 'show'])->middleware('token.ability:products.read');
        Route::match(['put', 'patch'], 'products/{product}', [ProductController::class, 'update'])->middleware('token.ability:products.update');
        Route::delete('products/{product}', [ProductController::class, 'destroy'])->middleware('token.ability:products.delete');

        Route::get('warehouses', [WarehouseController::class, 'index'])->middleware('token.ability:warehouses.read');
        Route::post('warehouses', [WarehouseController::class, 'store'])->middleware('token.ability:warehouses.create');
        Route::get('warehouses/{warehouse}', [WarehouseController::class, 'show'])->middleware('token.ability:warehouses.read');
        Route::match(['put', 'patch'], 'warehouses/{warehouse}', [WarehouseController::class, 'update'])->middleware('token.ability:warehouses.update');
        Route::patch('warehouses/{warehouse}/map', [WarehouseController::class, 'updateMap'])->middleware('token.ability:warehouses.update');
        Route::get('warehouses/{warehouse}/addresses', [WarehouseAddressController::class, 'index'])->middleware('token.ability:warehouses.read');
        Route::post('warehouses/{warehouse}/addresses', [WarehouseAddressController::class, 'store'])->middleware('token.ability:warehouses.update');
        Route::match(['put', 'patch'], 'warehouses/{warehouse}/addresses/{warehouseAddress}', [WarehouseAddressController::class, 'update'])->middleware('token.ability:warehouses.update');
        Route::delete('warehouses/{warehouse}/addresses/{warehouseAddress}', [WarehouseAddressController::class, 'destroy'])->middleware('token.ability:warehouses.update');
        Route::delete('warehouses/{warehouse}', [WarehouseController::class, 'destroy'])->middleware('token.ability:warehouses.delete');

        Route::get('tasks', [TaskController::class, 'index'])->middleware('token.ability:tasks.read');
        Route::post('tasks', [TaskController::class, 'store'])->middleware('token.ability:tasks.create');
        Route::get('tasks/{task}', [TaskController::class, 'show'])->middleware('token.ability:tasks.read');
        Route::match(['put', 'patch'], 'tasks/{task}', [TaskController::class, 'update'])->middleware('token.ability:tasks.update');
        Route::delete('tasks/{task}', [TaskController::class, 'destroy'])->middleware('token.ability:tasks.delete');
        Route::patch('tasks/{task}/complete', [TaskController::class, 'complete'])->middleware('token.ability:tasks.update');
        Route::patch('tasks/{task}/status', [TaskController::class, 'updateStatus'])->middleware('token.ability:tasks.update');

        Route::get('projects', [ProjectController::class, 'index'])->middleware('token.ability:projects.read');
        Route::post('projects', [ProjectController::class, 'store'])->middleware('token.ability:projects.create');
        Route::get('projects/{project}', [ProjectController::class, 'show'])->middleware('token.ability:projects.read');
        Route::match(['put', 'patch'], 'projects/{project}', [ProjectController::class, 'update'])->middleware('token.ability:projects.update');
        Route::delete('projects/{project}', [ProjectController::class, 'destroy'])->middleware('token.ability:projects.delete');
        Route::patch('projects/{project}/tasks/{task}/stage', [ProjectController::class, 'updateTaskStage'])->middleware('token.ability:projects.update');

        Route::get('disks', [DiskController::class, 'index'])->middleware('token.ability:disks.read');
        Route::post('disks', [DiskController::class, 'store'])->middleware('token.ability:disks.create');
        Route::get('disks/{disk}', [DiskController::class, 'show'])->middleware('token.ability:disks.read');
        Route::match(['put', 'patch'], 'disks/{disk}', [DiskController::class, 'update'])->middleware('token.ability:disks.update');
        Route::delete('disks/{disk}', [DiskController::class, 'destroy'])->middleware('token.ability:disks.delete');
        Route::get('disks/{disk}/download', [DiskController::class, 'download'])->middleware('token.ability:disks.read');

        Route::get('hr/settings', [HrSettingsController::class, 'show'])->middleware('token.ability:hr.read');
        Route::match(['put', 'patch'], 'hr/settings', [HrSettingsController::class, 'update'])->middleware('token.ability:hr.update');
        Route::get('hr/requests', [HrRequestController::class, 'index'])->middleware('token.ability:hr.read');
        Route::post('hr/requests', [HrRequestController::class, 'store'])->middleware('token.ability:hr.create');
        Route::get('hr/requests/{hrRequest}', [HrRequestController::class, 'show'])->middleware('token.ability:hr.read');
        Route::match(['put', 'patch'], 'hr/requests/{hrRequest}', [HrRequestController::class, 'update'])->middleware('token.ability:hr.update');
        Route::delete('hr/requests/{hrRequest}', [HrRequestController::class, 'destroy'])->middleware('token.ability:hr.delete');

        Route::get('telephony/settings', [TelephonySettingsController::class, 'show'])->middleware('token.ability:telephony.read');
        Route::match(['put', 'patch'], 'telephony/settings', [TelephonySettingsController::class, 'update'])->middleware('token.ability:telephony.update');

        Route::get('telephony/calls', [TelephonyCallController::class, 'index'])->middleware('token.ability:telephony.read');
        Route::post('telephony/calls', [TelephonyCallController::class, 'store'])->middleware('token.ability:telephony.create');
        Route::get('telephony/calls/{call}', [TelephonyCallController::class, 'show'])->middleware('token.ability:telephony.read');
        Route::match(['put', 'patch'], 'telephony/calls/{call}', [TelephonyCallController::class, 'update'])->middleware('token.ability:telephony.update');
        Route::delete('telephony/calls/{call}', [TelephonyCallController::class, 'destroy'])->middleware('token.ability:telephony.delete');

        Route::get('messengers/settings', [MessengerSettingsController::class, 'show'])->middleware('token.ability:messengers.read');
        Route::match(['put', 'patch'], 'messengers/settings', [MessengerSettingsController::class, 'update'])->middleware('token.ability:messengers.update');

        Route::get('messengers/channels', [MessengerChannelController::class, 'index'])->middleware('token.ability:messengers.read');
        Route::post('messengers/channels', [MessengerChannelController::class, 'store'])->middleware('token.ability:messengers.create');
        Route::get('messengers/channels/{channel}', [MessengerChannelController::class, 'show'])->middleware('token.ability:messengers.read');
        Route::match(['put', 'patch'], 'messengers/channels/{channel}', [MessengerChannelController::class, 'update'])->middleware('token.ability:messengers.update');
        Route::delete('messengers/channels/{channel}', [MessengerChannelController::class, 'destroy'])->middleware('token.ability:messengers.delete');

        Route::get('messengers/conversations', [MessengerConversationController::class, 'index'])->middleware('token.ability:messengers.read');
        Route::post('messengers/conversations', [MessengerConversationController::class, 'store'])->middleware('token.ability:messengers.create');
        Route::get('messengers/conversations/{conversation}', [MessengerConversationController::class, 'show'])->middleware('token.ability:messengers.read');
        Route::match(['put', 'patch'], 'messengers/conversations/{conversation}', [MessengerConversationController::class, 'update'])->middleware('token.ability:messengers.update');
        Route::patch('messengers/conversations/{conversation}/accept', [MessengerConversationController::class, 'accept'])->middleware('token.ability:messengers.update');
        Route::delete('messengers/conversations/{conversation}', [MessengerConversationController::class, 'destroy'])->middleware('token.ability:messengers.delete');
        Route::get('messengers/conversations/{conversation}/messages', [MessengerMessageController::class, 'index'])->middleware('token.ability:messengers.read');
        Route::post('messengers/conversations/{conversation}/messages', [MessengerMessageController::class, 'store'])->middleware('token.ability:messengers.create');

        Route::get('messengers/messages/{message}', [MessengerMessageController::class, 'show'])->middleware('token.ability:messengers.read');
        Route::match(['put', 'patch'], 'messengers/messages/{message}', [MessengerMessageController::class, 'update'])->middleware('token.ability:messengers.update');
        Route::delete('messengers/messages/{message}', [MessengerMessageController::class, 'destroy'])->middleware('token.ability:messengers.delete');

        Route::get('mail/settings', [MailSettingsController::class, 'show'])->middleware('token.ability:mail.read');
        Route::match(['put', 'patch'], 'mail/settings', [MailSettingsController::class, 'update'])->middleware('token.ability:mail.update');

        Route::get('mail/mailboxes', [MailboxController::class, 'index'])->middleware('token.ability:mail.read');
        Route::post('mail/mailboxes', [MailboxController::class, 'store'])->middleware('token.ability:mail.create');
        Route::get('mail/mailboxes/{mailbox}', [MailboxController::class, 'show'])->middleware('token.ability:mail.read');
        Route::match(['put', 'patch'], 'mail/mailboxes/{mailbox}', [MailboxController::class, 'update'])->middleware('token.ability:mail.update');
        Route::delete('mail/mailboxes/{mailbox}', [MailboxController::class, 'destroy'])->middleware('token.ability:mail.delete');

        Route::get('onec/settings', [OneCSettingsController::class, 'show'])->middleware('token.ability:onec.read');
        Route::match(['put', 'patch'], 'onec/settings', [OneCSettingsController::class, 'update'])->middleware('token.ability:onec.update');

        Route::get('updates/settings', [UpdateCenterController::class, 'show'])->middleware('token.ability:updates.read');
        Route::match(['put', 'patch'], 'updates/settings', [UpdateCenterController::class, 'update'])->middleware('token.ability:updates.update');
        Route::get('updates/checks', [UpdateCenterController::class, 'checks'])->middleware('token.ability:updates.read');
        Route::get('updates/installations', [UpdateCenterController::class, 'installations'])->middleware('token.ability:updates.read');
        Route::post('updates/checks', [UpdateCenterController::class, 'runCheck'])->middleware('token.ability:updates.create');
        Route::post('updates/installations', [UpdateCenterController::class, 'install'])->middleware('token.ability:updates.create');

        Route::get('onec/exchanges', [OneCExchangeController::class, 'index'])->middleware('token.ability:onec.read');
        Route::post('onec/exchanges', [OneCExchangeController::class, 'store'])->middleware('token.ability:onec.create');
        Route::get('onec/exchanges/{exchange}', [OneCExchangeController::class, 'show'])->middleware('token.ability:onec.read');
        Route::match(['put', 'patch'], 'onec/exchanges/{exchange}', [OneCExchangeController::class, 'update'])->middleware('token.ability:onec.update');
        Route::patch('onec/exchanges/{exchange}/retry', [OneCExchangeController::class, 'retry'])->middleware('token.ability:onec.update');
        Route::delete('onec/exchanges/{exchange}', [OneCExchangeController::class, 'destroy'])->middleware('token.ability:onec.delete');
    });
});
