@php
    $settingsSection = isset($settingsSection) && is_string($settingsSection) ? $settingsSection : null;
    $accessUsers = ($accessUsers ?? collect()) instanceof \Illuminate\Support\Collection
        ? $accessUsers
        : collect($accessUsers ?? []);
    $accessGroups = ($accessGroups ?? collect()) instanceof \Illuminate\Support\Collection
        ? $accessGroups
        : collect($accessGroups ?? []);
    $accessRoles = is_array($accessRoles ?? null) ? $accessRoles : \App\Support\AccessControl::roles();
    $accessEntities = is_array($accessEntities ?? null) ? $accessEntities : \App\Support\AccessControl::entities();
    $accessActions = is_array($accessActions ?? null) ? $accessActions : \App\Support\AccessControl::actions();
@endphp

<section class="space-y-6">
    <header>
        <h2 class="text-lg font-medium text-gray-900">{{ __('Access Settings') }}</h2>
        <p class="mt-1 text-sm text-gray-600">
            {{ __('Roles: Administrator, Moderator, User. For each employee, you can set personal rights for CRM entities.') }}
        </p>
    </header>

    @if (session('status') === 'access-updated')
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
            {{ __('Permissions have been updated.') }}
        </div>
    @endif
    @if (session('status') === 'access-group-created')
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
            {{ __('Access group has been created.') }}
        </div>
    @endif
    @if (session('status') === 'access-group-updated')
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
            {{ __('Access group has been updated.') }}
        </div>
    @endif
    @if (session('status') === 'access-group-deleted')
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
            {{ __('Access group has been deleted.') }}
        </div>
    @endif
    @if (session('status') === 'access-group-assigned')
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
            {{ __('Users were assigned to the selected group.') }}
        </div>
    @endif

    <div class="rounded-lg border border-slate-200 bg-white p-4">
        <h3 class="text-base font-semibold text-slate-900">{{ __('Access groups') }}</h3>
        <p class="mt-1 text-sm text-slate-600">{{ __('Create reusable permission groups and assign them to users.') }}</p>

        <div class="mt-4 rounded-lg border border-slate-200 p-4">
            <h4 class="text-sm font-semibold text-slate-800">{{ __('Create group') }}</h4>
            <form method="POST" action="{{ route('profile.access.groups.store') }}" class="mt-3 space-y-4">
                @csrf
                @if ($settingsSection)
                    <input type="hidden" name="_settings_section" value="{{ $settingsSection }}">
                @endif

                <div>
                    <label for="access-group-create-name" class="block text-sm font-medium text-slate-700">{{ __('Group name') }}</label>
                    <input
                        id="access-group-create-name"
                        type="text"
                        name="group_name"
                        value="{{ old('group_name') }}"
                        class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        required
                    >
                </div>

                <div class="overflow-hidden rounded-lg border border-slate-200">
                    <table class="min-w-full divide-y divide-slate-200">
                        <thead class="bg-slate-50">
                            <tr>
                                <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Essence') }}</th>
                                @foreach ($accessActions as $actionKey => $actionLabel)
                                    <th class="px-3 py-2 text-center text-xs font-semibold uppercase tracking-wide text-slate-600">{{ $actionLabel }}</th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-100 bg-white">
                            @foreach ($accessEntities as $entityKey => $entityLabel)
                                <tr>
                                    <td class="px-3 py-2 text-sm font-medium text-slate-800">{{ $entityLabel }}</td>
                                    @foreach ($accessActions as $actionKey => $actionLabel)
                                        <td class="px-3 py-2 text-center">
                                            <input
                                                type="checkbox"
                                                name="permissions[{{ $entityKey }}][{{ $actionKey }}]"
                                                value="1"
                                                class="rounded border-slate-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                                                @checked((bool) old("permissions.{$entityKey}.{$actionKey}"))
                                            >
                                        </td>
                                    @endforeach
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <x-input-error class="mt-2" :messages="$errors->get('group_name')" />

                <div class="flex items-center justify-end">
                    <x-primary-button>{{ __('Create group') }}</x-primary-button>
                </div>
            </form>
        </div>

        @if ($accessGroups->isEmpty())
            <div class="mt-4 rounded-lg border border-slate-200 bg-slate-50 px-4 py-3 text-sm text-slate-600">
                {{ __('No access groups created yet.') }}
            </div>
        @else
            <div class="mt-4 space-y-3">
                @foreach ($accessGroups as $group)
                    @php
                        $groupPermissions = is_array($group->permissions) ? $group->permissions : [];
                        $isGroupOpen = (int) old('group_id', 0) === (int) $group->id;
                    @endphp
                    <details class="rounded-lg border border-slate-200 bg-slate-50" @if($isGroupOpen) open @endif>
                        <summary class="cursor-pointer list-none px-4 py-3">
                            <div class="flex items-center justify-between gap-3">
                                <div class="min-w-0">
                                    <p class="truncate text-sm font-semibold text-slate-900">{{ $group->name }}</p>
                                    <p class="truncate text-xs text-slate-500">{{ __('Users in group') }}: {{ (int) ($group->users_count ?? 0) }}</p>
                                </div>
                            </div>
                        </summary>

                        <div class="border-t border-slate-200 px-4 py-4">
                            <form method="POST" action="{{ route('profile.access.groups.update', ['group' => $group->id]) }}" class="space-y-4">
                                @csrf
                                @method('PATCH')
                                <input type="hidden" name="group_id" value="{{ $group->id }}">
                                @if ($settingsSection)
                                    <input type="hidden" name="_settings_section" value="{{ $settingsSection }}">
                                @endif

                                <div>
                                    <label for="access-group-name-{{ $group->id }}" class="block text-sm font-medium text-slate-700">{{ __('Group name') }}</label>
                                    <input
                                        id="access-group-name-{{ $group->id }}"
                                        type="text"
                                        name="group_name"
                                        value="{{ (string) old('group_id') === (string) $group->id ? old('group_name', $group->name) : $group->name }}"
                                        class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                        required
                                    >
                                </div>

                                <div class="overflow-hidden rounded-lg border border-slate-200">
                                    <table class="min-w-full divide-y divide-slate-200">
                                        <thead class="bg-white">
                                            <tr>
                                                <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Essence') }}</th>
                                                @foreach ($accessActions as $actionKey => $actionLabel)
                                                    <th class="px-3 py-2 text-center text-xs font-semibold uppercase tracking-wide text-slate-600">{{ $actionLabel }}</th>
                                                @endforeach
                                            </tr>
                                        </thead>
                                        <tbody class="divide-y divide-slate-100 bg-white">
                                            @foreach ($accessEntities as $entityKey => $entityLabel)
                                                <tr>
                                                    <td class="px-3 py-2 text-sm font-medium text-slate-800">{{ $entityLabel }}</td>
                                                    @foreach ($accessActions as $actionKey => $actionLabel)
                                                        @php
                                                            $permissionKey = "{$entityKey}.{$actionKey}";
                                                            $checked = (string) old('group_id') === (string) $group->id
                                                                ? (bool) old("permissions.{$entityKey}.{$actionKey}")
                                                                : (bool) ($groupPermissions[$permissionKey] ?? false);
                                                        @endphp
                                                        <td class="px-3 py-2 text-center">
                                                            <input
                                                                type="checkbox"
                                                                name="permissions[{{ $entityKey }}][{{ $actionKey }}]"
                                                                value="1"
                                                                class="rounded border-slate-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                                                                @checked($checked)
                                                            >
                                                        </td>
                                                    @endforeach
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                @if ((string) old('group_id') === (string) $group->id)
                                    <x-input-error class="mt-2" :messages="$errors->get('group_name')" />
                                @endif

                                <div class="flex items-center justify-end">
                                    <x-primary-button>{{ __('Save group') }}</x-primary-button>
                                </div>
                            </form>

                            <form method="POST" action="{{ route('profile.access.groups.destroy', ['group' => $group->id]) }}" class="mt-3 flex items-center justify-end" onsubmit="return confirm('{{ __('Delete group?') }}')">
                                @csrf
                                @method('DELETE')
                                @if ($settingsSection)
                                    <input type="hidden" name="_settings_section" value="{{ $settingsSection }}">
                                @endif
                                <button type="submit" class="inline-flex items-center rounded-md border border-red-300 px-3 py-2 text-sm font-medium text-red-600 hover:bg-red-50">
                                    {{ __('Delete group') }}
                                </button>
                            </form>
                        </div>
                    </details>
                @endforeach
            </div>
        @endif
    </div>

    <div class="rounded-lg border border-slate-200 bg-white p-4">
        <h3 class="text-base font-semibold text-slate-900">{{ __('Bulk group assignment') }}</h3>
        <p class="mt-1 text-sm text-slate-600">{{ __('Select users and assign one group to all selected users.') }}</p>

        <form method="POST" action="{{ route('profile.access.groups.bulk-assign') }}" class="mt-4 space-y-4">
            @csrf
            @method('PATCH')
            @if ($settingsSection)
                <input type="hidden" name="_settings_section" value="{{ $settingsSection }}">
            @endif

            <div>
                <label for="bulk-access-group-id" class="block text-sm font-medium text-slate-700">{{ __('Group') }}</label>
                <select id="bulk-access-group-id" name="access_group_id" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">{{ __('No group') }}</option>
                    @foreach ($accessGroups as $group)
                        <option value="{{ $group->id }}" @selected((string) old('access_group_id') === (string) $group->id)>
                            {{ $group->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="rounded-lg border border-slate-200 p-3">
                <p class="text-sm font-medium text-slate-700">{{ __('Users') }}</p>
                <div class="mt-3 grid grid-cols-1 gap-2 md:grid-cols-2">
                    @foreach ($accessUsers as $member)
                        <label class="inline-flex items-center gap-2 rounded-md border border-slate-200 bg-slate-50 px-3 py-2 text-sm text-slate-700">
                            <input
                                type="checkbox"
                                name="selected_user_ids[]"
                                value="{{ $member->id }}"
                                class="rounded border-slate-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                                @checked(in_array((string) $member->id, array_map('strval', (array) old('selected_user_ids', [])), true))
                            >
                            <span class="truncate">{{ $member->name }} <span class="text-xs text-slate-500">({{ $member->email }})</span></span>
                        </label>
                    @endforeach
                </div>
            </div>

            <x-input-error class="mt-2" :messages="$errors->get('selected_user_ids')" />
            <x-input-error class="mt-2" :messages="$errors->get('selected_user_ids.*')" />
            <x-input-error class="mt-2" :messages="$errors->get('access_group_id')" />

            <div class="flex items-center justify-end">
                <x-primary-button>{{ __('Assign group to selected users') }}</x-primary-button>
            </div>
        </form>
    </div>

    @if ($accessUsers->isEmpty())
        <div class="rounded-lg border border-slate-200 bg-slate-50 px-4 py-3 text-sm text-slate-600">
            No users were found to configure access.
        </div>
    @else
        <div class="space-y-4">
            @foreach ($accessUsers as $member)
                @php
                    $resolvedPermissions = \App\Support\AccessControl::resolvedPermissions($member);
                    $normalizedRole = \App\Support\AccessControl::normalizeRole((string) $member->role);
                    $customPermissions = is_array($member->permissions) ? $member->permissions : [];
                    $hasCustomPermissions = $customPermissions !== [];
                    $isOpen = (int) old('user_id', 0) === (int) $member->id;
                    $currentGroupName = $member->accessGroup?->name;
                @endphp

                <details class="rounded-lg border border-slate-200 bg-white" @if($isOpen) open @endif>
                    <summary class="cursor-pointer list-none px-4 py-3">
                        <div class="flex items-center justify-between gap-3">
                            <div class="min-w-0">
                                <p class="truncate text-sm font-semibold text-slate-900">{{ $member->name }}</p>
                                <p class="truncate text-xs text-slate-500">
                                    {{ $member->email }}
                                    · {{ __('Current role') }}: {{ $accessRoles[$normalizedRole] ?? $normalizedRole }}
                                    · {{ __('Group') }}: {{ $currentGroupName ?: __('No group') }}
                                </p>
                            </div>
                            <span class="rounded-full bg-slate-100 px-2 py-1 text-[11px] font-semibold text-slate-700">
                                {{ $hasCustomPermissions ? __('Personal rights configured') : __('Only role/group') }}
                            </span>
                        </div>
                    </summary>

                    <div class="border-t border-slate-200 px-4 py-4">
                        <form method="POST" action="{{ route('profile.access.update') }}" class="space-y-4">
                            @csrf
                            @method('PATCH')
                            <input type="hidden" name="user_id" value="{{ $member->id }}">
                            @if ($settingsSection)
                                <input type="hidden" name="_settings_section" value="{{ $settingsSection }}">
                            @endif

                            <div class="grid grid-cols-1 gap-3 md:grid-cols-2">
                                <div>
                                    <label for="role_user_{{ $member->id }}" class="block text-sm font-medium text-slate-700">{{ __('User Role') }}</label>
                                    <select id="role_user_{{ $member->id }}" name="role" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                        @foreach ($accessRoles as $roleKey => $roleLabel)
                                            <option value="{{ $roleKey }}" @selected((string) old('user_id') === (string) $member->id && (string) old('role') === (string) $roleKey || ((string) old('user_id') !== (string) $member->id && $normalizedRole === $roleKey))>
                                                {{ $roleLabel }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div>
                                    <label for="access_group_id_{{ $member->id }}" class="block text-sm font-medium text-slate-700">{{ __('Group') }}</label>
                                    <select id="access_group_id_{{ $member->id }}" name="access_group_id" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                        <option value="">{{ __('No group') }}</option>
                                        @foreach ($accessGroups as $group)
                                            <option
                                                value="{{ $group->id }}"
                                                @selected(
                                                    (string) old('user_id') === (string) $member->id
                                                        ? (string) old('access_group_id', '') === (string) $group->id
                                                        : (string) ($member->access_group_id ?? '') === (string) $group->id
                                                )
                                            >
                                                {{ $group->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="overflow-hidden rounded-lg border border-slate-200">
                                <table class="min-w-full divide-y divide-slate-200">
                                    <thead class="bg-slate-50">
                                        <tr>
                                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Essence') }}</th>
                                            @foreach ($accessActions as $actionKey => $actionLabel)
                                                <th class="px-3 py-2 text-center text-xs font-semibold uppercase tracking-wide text-slate-600">{{ $actionLabel }}</th>
                                            @endforeach
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-slate-100 bg-white">
                                        @foreach ($accessEntities as $entityKey => $entityLabel)
                                            <tr>
                                                <td class="px-3 py-2 text-sm font-medium text-slate-800">{{ $entityLabel }}</td>
                                                @foreach ($accessActions as $actionKey => $actionLabel)
                                                    <td class="px-3 py-2 text-center">
                                                        <input
                                                            type="checkbox"
                                                            name="permissions[{{ $entityKey }}][{{ $actionKey }}]"
                                                            value="1"
                                                            class="rounded border-slate-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                                                            @checked(
                                                                (string) old('user_id') === (string) $member->id
                                                                    ? (bool) old("permissions.{$entityKey}.{$actionKey}")
                                                                    : (bool) ($resolvedPermissions[$entityKey][$actionKey] ?? false)
                                                            )
                                                        >
                                                    </td>
                                                @endforeach
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            @if ((string) old('user_id') === (string) $member->id)
                                <x-input-error class="mt-2" :messages="$errors->get('role')" />
                                <x-input-error class="mt-2" :messages="$errors->get('user_id')" />
                                <x-input-error class="mt-2" :messages="$errors->get('access_group_id')" />
                            @endif

                            <div class="flex items-center justify-end">
                                <x-primary-button>{{ __('Save access') }}</x-primary-button>
                            </div>
                        </form>
                    </div>
                </details>
            @endforeach
        </div>
    @endif
</section>
