<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">New funnel</h2>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6">
            <form method="POST" action="{{ route('pipelines.store') }}" class="bg-white border border-gray-200 rounded-xl p-6 space-y-4">
                @csrf

                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
                    <input id="name" name="name" type="text" required value="{{ old('name') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                    <textarea id="description" name="description" rows="3" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('description') }}</textarea>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="sort_order" class="block text-sm font-medium text-gray-700">Order</label>
                        <input id="sort_order" name="sort_order" type="number" min="0" value="{{ old('sort_order', 0) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>

                    <div class="flex items-center gap-6 pt-6">
                        <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                            <input type="checkbox" name="is_active" value="1" @checked(old('is_active', true)) class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                            Active
                        </label>
                        <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                            <input type="checkbox" name="is_default" value="1" @checked(old('is_default')) class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                            Default
                        </label>
                    </div>
                </div>

                <div>
                    <label for="stages" class="block text-sm font-medium text-gray-700">Stages (each on a new line)</label>
                    <textarea id="stages" name="stages" rows="8" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="New lead&#10;Qualification&#10;Offer&#10;Negotiation&#10;Success&#10;Failure">{{ old('stages', "New lead\nQualification\nOffer\nNegotiation\nSuccess\nFailure") }}</textarea>
                    <p class="mt-1 text-xs text-gray-500">The "Success/Failure" stages will be used as final stages.</p>
                </div>

                <div class="flex items-center justify-end gap-3">
                    <a href="{{ route('pipelines.index') }}" class="px-4 py-2 text-sm text-gray-700">Cancel</a>
                    <button type="submit" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">Create</button>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>
