@php
    $sectionAccessEntity = (string) ($sectionAccessEntity ?? '');
    $sectionAccessTitle = (string) ($sectionAccessTitle ?? '');
    $sectionAccessUsers = ($sectionAccessUsers ?? collect()) instanceof \Illuminate\Support\Collection
        ? $sectionAccessUsers
        : collect($sectionAccessUsers ?? []);
    $canManageSectionAccess = (bool) ($canManageSectionAccess ?? false);
    $accessActions = \App\Support\AccessControl::actions();
    $modalName = 'section-access-'.$sectionAccessEntity;
@endphp

@if ($canManageSectionAccess)
    <button
        type="button"
        x-data
        @click="$dispatch('open-modal', '{{ $modalName }}')"
        class="inline-flex h-10 w-10 items-center justify-center rounded-md border border-gray-300 bg-white text-gray-600 hover:bg-gray-50 hover:text-gray-800"
        title="{{ __('Manage section access') }}"
    >
        <x-menu-icon name="fa-solid fa-gear" class="h-4 w-4" />
    </button>

    <x-modal :name="$modalName" maxWidth="2xl">
        <div class="p-6">
            <div class="mb-4 flex items-start justify-between gap-3">
                <div>
                    <h3 class="text-base font-semibold text-gray-900">{{ __('Section access') }}: {{ $sectionAccessTitle }}</h3>
                    <p class="mt-1 text-sm text-gray-600">{{ __('Set rights for users on this section.') }}</p>
                </div>
                <button
                    type="button"
                    x-data
                    @click="$dispatch('close-modal', '{{ $modalName }}')"
                    class="inline-flex h-8 w-8 items-center justify-center rounded-md border border-gray-300 text-gray-500 hover:bg-gray-50 hover:text-gray-700"
                    title="{{ __('Close') }}"
                >
                    <x-menu-icon name="fa-solid fa-xmark" class="h-4 w-4" />
                </button>
            </div>

            <div class="max-h-[70vh] space-y-3 overflow-y-auto pr-1">
                @forelse ($sectionAccessUsers as $member)
                    <form method="POST" action="{{ route('section-access.update', ['entity' => $sectionAccessEntity]) }}" class="rounded-lg border border-slate-200 bg-slate-50 p-3">
                        @csrf
                        @method('PATCH')
                        <input type="hidden" name="user_id" value="{{ $member->id }}">

                        <div class="mb-3">
                            <p class="text-sm font-semibold text-slate-900">{{ $member->name }}</p>
                            <p class="text-xs text-slate-500">{{ $member->email }}</p>
                        </div>

                        <div class="grid grid-cols-2 gap-2 md:grid-cols-4">
                            @foreach ($accessActions as $actionKey => $actionLabel)
                                <label class="inline-flex items-center gap-2 rounded-md border border-slate-200 bg-white px-2.5 py-2 text-xs text-slate-700">
                                    <input
                                        type="checkbox"
                                        name="permissions[{{ $actionKey }}]"
                                        value="1"
                                        class="rounded border-slate-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                                        @checked(\App\Support\AccessControl::allows($member, $sectionAccessEntity, $actionKey))
                                    >
                                    <span>{{ $actionLabel }}</span>
                                </label>
                            @endforeach
                        </div>

                        <div class="mt-3 flex justify-end">
                            <button type="submit" class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-xs font-medium text-white hover:bg-indigo-500">
                                {{ __('Save access') }}
                            </button>
                        </div>
                    </form>
                @empty
                    <div class="rounded-lg border border-slate-200 bg-slate-50 px-3 py-3 text-sm text-slate-600">
                        {{ __('No users found.') }}
                    </div>
                @endforelse
            </div>
        </div>
    </x-modal>
@endif

