<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <div>
                <h2 class="text-xl font-semibold leading-tight text-gray-800">{{ __('HR Service') }}</h2>
                <p class="text-sm text-gray-500">{{ __('Employee requests, approvals, and HR integrations in a single workspace.') }}</p>
            </div>
            <div class="flex items-center gap-2">
                @include('partials.section-access-controls', [
                    'sectionAccessEntity' => 'hr',
                    'sectionAccessTitle' => __('HR Service'),
                    'canManageSectionAccess' => $canManageSectionAccess ?? false,
                    'sectionAccessUsers' => $sectionAccessUsers ?? collect(),
                ])
            </div>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full space-y-4 px-6">
            <p class="sr-only">HR requests</p>
            <div class="rounded-2xl border border-slate-200/70 bg-white/70 p-3 shadow-sm backdrop-blur-sm">
                <div data-vue-app="hr">
                    <script type="application/json" data-vue-props>@json($hrPayload)</script>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
