<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('web_forms', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('owner_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->string('submit_label', 80)->default('Submit');
            $table->boolean('show_reset_button')->default(false);
            $table->string('reset_label', 80)->default('Clear');
            $table->string('success_message', 255)->default('The form has been submitted successfully.');
            $table->boolean('is_active')->default(true);
            $table->string('behavior', 40)->default('create_task');
            $table->json('behavior_settings')->nullable();
            $table->json('fields');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('web_forms');
    }
};
