<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasTable('users')) {
            return;
        }

        Schema::table('users', function (Blueprint $table): void {
            if (! Schema::hasColumn('users', 'profile_photo_path')) {
                $table->string('profile_photo_path')->nullable()->after('locale');
            }

            if (! Schema::hasColumn('users', 'profile_photo_focus_x')) {
                $table->unsignedTinyInteger('profile_photo_focus_x')->default(50)->after('profile_photo_path');
            }

            if (! Schema::hasColumn('users', 'profile_photo_focus_y')) {
                $table->unsignedTinyInteger('profile_photo_focus_y')->default(50)->after('profile_photo_focus_x');
            }

            if (! Schema::hasColumn('users', 'profile_photo_zoom')) {
                $table->decimal('profile_photo_zoom', 4, 2)->default(1.00)->after('profile_photo_focus_y');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (! Schema::hasTable('users')) {
            return;
        }

        Schema::table('users', function (Blueprint $table): void {
            if (Schema::hasColumn('users', 'profile_photo_zoom')) {
                $table->dropColumn('profile_photo_zoom');
            }

            if (Schema::hasColumn('users', 'profile_photo_focus_y')) {
                $table->dropColumn('profile_photo_focus_y');
            }

            if (Schema::hasColumn('users', 'profile_photo_focus_x')) {
                $table->dropColumn('profile_photo_focus_x');
            }

            if (Schema::hasColumn('users', 'profile_photo_path')) {
                $table->dropColumn('profile_photo_path');
            }
        });
    }
};
