<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\OrganizationCompany>
 */
class OrganizationCompanyFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->company(),
            'logo_path' => null,
            'requisites' => fake()->optional()->sentence(),
            'address' => fake()->optional()->address(),
            'phones' => [fake()->phoneNumber()],
            'sort_order' => 0,
            'parent_id' => null,
        ];
    }
}
