<?php

namespace Database\Factories;

use App\Models\Pipeline;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DealStage>
 */
class DealStageFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = fake()->randomElement(['New Lead', 'Qualification', 'Proposal', 'Negotiation', 'Won', 'Lost']);
        $isWon = $name === 'Won';
        $isLost = $name === 'Lost';
        $defaultColor = $isWon ? '#10B981' : ($isLost ? '#EF4444' : fake()->randomElement([
            '#3B82F6',
            '#0EA5E9',
            '#8B5CF6',
            '#F59E0B',
            '#14B8A6',
            '#6366F1',
            '#EC4899',
            '#94A3B8',
        ]));

        return [
            'pipeline_id' => Pipeline::factory(),
            'name' => $name,
            'code' => Str::slug($name, '_').'_'.fake()->unique()->numberBetween(1, 1000),
            'sort_order' => fake()->numberBetween(0, 10),
            'probability' => $isWon ? 100 : ($isLost ? 0 : fake()->numberBetween(10, 80)),
            'color' => $defaultColor,
            'is_won' => $isWon,
            'is_lost' => $isLost,
        ];
    }
}
