<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WarehouseAddress extends Model
{
    /** @use HasFactory<\Database\Factories\WarehouseAddressFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'warehouse_id',
        'code',
        'zone',
        'aisle',
        'rack',
        'shelf',
        'cell',
        'x',
        'y',
        'color',
        'capacity',
        'current_load',
        'status',
        'note',
        'created_by',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'warehouse_id' => 'integer',
            'x' => 'integer',
            'y' => 'integer',
            'capacity' => 'decimal:3',
            'current_load' => 'decimal:3',
            'created_by' => 'integer',
        ];
    }

    public function warehouse(): BelongsTo
    {
        return $this->belongsTo(Warehouse::class);
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}

