<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OneCExchange extends Model
{
    /** @use HasFactory<\Database\Factories\OneCExchangeFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'external_id',
        'direction',
        'entity',
        'action',
        'status',
        'payload',
        'response',
        'error_message',
        'started_at',
        'finished_at',
        'initiated_by_user_id',
        'meta',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'payload' => 'array',
            'response' => 'array',
            'started_at' => 'datetime',
            'finished_at' => 'datetime',
            'initiated_by_user_id' => 'integer',
            'meta' => 'array',
        ];
    }

    public function initiatedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'initiated_by_user_id');
    }
}

