<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MailServiceSetting extends Model
{
    /** @use HasFactory<\Database\Factories\MailServiceSettingFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'provider',
        'is_active',
        'domain',
        'api_base_url',
        'api_key',
        'api_secret',
        'account_id',
        'webhook_secret',
        'auto_provision_on_registration',
        'auto_provision_on_user_create',
        'default_status',
        'default_quota_mb',
        'meta',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
            'auto_provision_on_registration' => 'boolean',
            'auto_provision_on_user_create' => 'boolean',
            'default_quota_mb' => 'integer',
            'meta' => 'array',
        ];
    }
}

